from sqlalchemy import create_engine, Column, Integer, String, Text, Boolean, Date, DECIMAL, TIMESTAMP, ForeignKey
from sqlalchemy.orm import declarative_base
from sqlalchemy.sql import func

Base = declarative_base()

class ShopInfo(Base):
    __tablename__ = 'shop_info'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    catalog_id = Column(Integer)
    dealer_id = Column(Integer)
    shop_name = Column(String(255), nullable=False)
    display_name = Column(String(255))
    login_name = Column(String(100), unique=True)
    password = Column(String(255))
    business_code = Column(String(100))
    pan_number = Column(String(20))
    shop_description = Column(Text)
    owner_name = Column(String(100))
    contact_person_name = Column(String(100))
    contact_person_mobile = Column(String(15))
    contact_email = Column(String(100), unique=True)
    phone_number = Column(String(15))
    mobile_number = Column(String(15))
    whatsapp_number = Column(String(15))
    address = Column(String(255))
    city = Column(String(100))
    state = Column(String(100))
    postal_code = Column(String(20))
    country = Column(String(100))
    municipality = Column(String(100))
    landmark = Column(String(255))
    latitude = Column(DECIMAL(9, 6))
    longitude = Column(DECIMAL(9, 6))
    website_url = Column(String(255))
    social_media_links = Column(Text)
    seo_keywords = Column(String(255))
    opening_hours = Column(String(100))
    featured_products = Column(Text)
    shop_type = Column(String(50))
    service_area = Column(String(255))
    business_category = Column(String(50))
    post_content = Column(Text)
    show_flag = Column(Boolean, default=True)
    lock_flag = Column(Boolean, default=False)
    verified_flag = Column(Boolean, default=False)
    verified_suppliers_flag = Column(Boolean, default=False)
    established_date = Column(Date)
    expiry_date = Column(Date)
    grace_day = Column(Integer)
    next_renew_date = Column(Date)
    payment_amount = Column(DECIMAL(10, 2))
    payment_reference_no = Column(String(100))
    payment_date = Column(Date)
    verify_date = Column(Date)
    no_of_store_visits = Column(Integer, default=0)
    no_of_followers = Column(Integer, default=0)
    no_of_experience_years = Column(Integer, default=0)
    dealing_brands = Column(Text)
    business_logo = Column(String(255))
    shop_cover_photo = Column(String(255))
    thumbnail = Column(String(255))
    youtube_ad = Column(String(255))
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class Product(Base):
    __tablename__ = 'products'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    catalog_id = Column(Integer)
    product_name = Column(String(255), nullable=False)
    product_description = Column(Text)
    brand = Column(String(100))
    category_id = Column(Integer, ForeignKey('categories.id'))  # Assuming a categories table
    size = Column(String(50))
    color = Column(String(50))
    origin = Column(String(100))
    price = Column(DECIMAL(10, 2), nullable=False)
    cus_code = Column(String(100))
    sn_no = Column(String(100))
    hot_product = Column(Boolean, default=False)
    featured_product = Column(Boolean, default=False)
    product_show_flag = Column(Boolean, default=True)
    product_lock_flag = Column(Boolean, default=False)
    seo_keywords = Column(String(255))
    seo_description = Column(Text)
    no_of_views = Column(Integer, default=0)
    video_url_1 = Column(String(255))
    video_url_2 = Column(String(255))
    video_url_3 = Column(String(255))
    recycled_flag = Column(Boolean, default=False)
    image_1 = Column(String(255))
    image_2 = Column(String(255))
    image_3 = Column(String(255))
    image_4 = Column(String(255))
    image_5 = Column(String(255))
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class Category(Base):
    __tablename__ = 'categories'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    category_name = Column(String(255), nullable=False)
    category_description = Column(Text)
    parent_category_id = Column(Integer, ForeignKey('categories.id'))
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())
