basic = {
    "src": {
        "type": "dir",
        "name": "src",
        "child": {
            "api": {
                "type": "dir",
                "name": "api",
                "child": {
                    "routes.py": {
                        "type": "file",
                        "name": "routes.py",
                        "content": """# 🛸 Generated by zPy
from src.di import zdi
from src.contexts.@context_name.application.@usecase_file import @usecase_class

from flask import Flask
from zpy.api.http.response import response_builder
from zpy.api.flask import create_app


api: Flask = create_app()


@api.route("/api/awesome", methods=["GET"])
@response_builder()
def awesome_api():
    return zdi[@usecase_class].execute(data={})"""
                    }
                }
            },
            "contexts": {
                "type": "dir",
                "name": "contexts",
                "child": {
                    "@context_name": {
                        "type": "dir",
                        "name": "@context_name",
                        "child": {
                            "application": {
                                "type": "dir",
                                "name": "application",
                                "child": {
                                    "@usecase_file.py": {
                                        "type": "file",
                                        "name": "@usecase_file.py",
                                        "content": """# 🛸 Generated by zPy
from typing import Any

from zpy.app.usecase import UseCase


from ..domain.repositories import @repository_name


class @usecase_class(UseCase[Any, Any]):
    \"\"\"
        Use Case description.
    \"\"\"

    def __init__(self, repository: @repository_name) -> None:
        super().__init__('@usecase_class')
        self.repository = repository

    def execute(self, data: Any, *args, **kwargs) -> None:
        # TODO Do magic with business rules 😁
        return self.repository.@repository_action(data)"""
                                    }
                                }

                            },
                            "domain": {
                                "type": "dir",
                                "name": "domain",
                                "child": {
                                    "catalogs.py": {
                                        "type": "file",
                                        "name": "catalogs.py",
                                        "content": """# 🛸 Generated by zPy
from enum import Enum

class SomeCatalog(Enum):
    \"\"\"
        Catalog example
    \"\"\"
    SOME_CONSTANT = 9
    ANOTHER_CONSTANT = 10"""
                                    },
                                    "repositories.py": {
                                        "type": "file",
                                        "name": "repositories.py",
                                        "content": """# 🛸 Generated by zPy
from abc import abstractmethod
from abc import ABC
from typing import Any


class @repository_name(ABC):
    @abstractmethod
    def @repository_action(self, data: Any) -> Any:
        \"\"\"
        Description

        :param data: input data
        :return: result
        \"\"\"
        ..."""
                                    }
                                }

                            },
                            "infrastructure": {
                                "type": "dir",
                                "name": "infrastructure",
                                "child": {
                                    "@repository_impl_file.py": {
                                        "type": "file",
                                        "name": "@repository_file.py",
                                        "content": """# 🛸 Generated by zPy
from ..domain.repositories import @repository_name
from typing import Any

class @repository_impl(@repository_name):

    def __init__(self):
        ...

    def @repository_action(self, data: Any) -> Any:
        try:
            # TODO Do magic with data 😁
            return "😁"
        finally:
            ..."""
                                    }
                                }

                            },
                            "__init__.py": {
                                "type": "file",
                                "name": "__init__.py",
                                "content": """# 🛸 Generated by zPy
# 🛰 Application Layer

from .application.@usecase_file import @usecase_class

# 📦  Domain Layer

from .domain.repositories import @repository_name


# Infrastructure

from .infrastructure.@repository_file import @repository_impl"""
                            }
                        }
                    }
                }
            },
            "di.py": {
                "type": "file",
                "name": "di.py",
                "content": """# 🛸 Generated by zPy
from zpy.containers.di_container import DIContainer, zdi
from zpy.utils import get_env_or_throw as var
from zpy.app.usecase import UseCase
from typing import Any


def initializer(di: DIContainer):
    # * Load Dependencies 🧬    
    from src.contexts.@context_name.domain.repositories import @repository_name
    from src.contexts.@context_name.infrastructure.@repository_file import @repository_impl
    from src.contexts.@context_name.application.@usecase_file import @usecase_class
    
    # Repositories 📦
    repository: @repository_name = @repository_impl()

    # Use cases ⚙️
    @usecase_var: UseCase[Any, Any] = @usecase_class(repository)
    
    # Dependencies registration ⚡
    di.factory_register(@usecase_class, lambda _: @usecase_var)
    
    
zdi.setup(initializer)"""
            },
            "handler.py": {
                "type": "file",
                "name": "handler.py",
                "content": """# 🛸 Generated by zPy
from typing import Any
from zpy.api.flask.cloud_handlers import aws_lambda
from zpy.api.flask.cloud_handlers import LambdaEventPipe

from src.api.routes import api
import aws_lambda_wsgi as awsgi


@aws_lambda()
def handle(event: dict, context: dict) -> Any:
    return LambdaEventPipe(event, context) \
        .run(lambda e, c: wsgi.response(api, e, c))"""
            }
        }
    },
    "tests": {
        "type": "dir",
        "name": "tests",
        "child": {
            "@usecase_file_test.py": {
                "type": "file",
                "name": "@usecase_file_test.py",
                "content": """# 🛸 Generated by zPy
from dotenv import load_dotenv
load_dotenv(dotenv_path="..\\.env")

from src.handler import handle

if __name__ == "__main__":
    handle({}, {})"""
            },
            "run_local_api.py": {
                "type": "file",
                "name": "run_local_api.py",
                "content": """# 🛸 Generated by zPy
from dotenv import load_dotenv
load_dotenv(
    dotenv_path="@base_path\\\\.env"
)

from src.api.routes import api

if __name__ == "__main__":
    api.run(host="127.0.0.1", port=5050, debug=True)"""
            }
        }
    },
    ".env": {
        "type": "file",
        "name": ".env",
        "content": "ENVIRONMENT=local\nORACLE_CLIENT_PATH=C:\oracle\win32\instantclient_19_9"
    },
    ".gitignore": {
        "type": "raw-file",
        "name": ".gitignore",
        "path": "ignore.py"
    },
    "package.json": {
        "type": "file",
        "content": """{
    "name": "@project_name",
    "version": "1.0.0"
}""",
        "name": "package.json"
    },
    "CHANGELOG.md": {
        "type": "file",
        "name": "CHANGELOG.md",
        "content": """# Change Log
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

## [1.0.0] - @date Project scaffolding generated for @project_name

> Author: @developer | @dev_url

### Added

- Project scaffolding configured
- Default Use Case implemented
- Default Repository Implementation"""
    },
    "README.md": {
        "type": "file",
        "name": "README.md",
        "content": """# @project_name

@project_description

## Getting Started

Clone this repository for local deploy.

### Prerequisites

- python3.9
- pip
- virtualenv

### Dependencies

Some dependencies are optional according to the requirements.
- zpy-api-core
- zpy-db-core
- boto3

For more information see requirements.txt file

### Installing

- Create virtual environment, activate it and download all dependencies.

```
  virtualenv venv
```

- Clone repository

```

git clone http-url-repository

```

## Running the tests

Load env vars

```bash
ENVIRONMENT=
```

Test use cases

```python

from src.di import @usecase_class

if __name__ == "__main__":
    @usecase_var.execute(@usecase_repository_dependency)


```

Or test from handler

`````python
from dotenv import load_dotenv

load_dotenv()

from src.handler import handle

if __name__ == "__main__":
    handle({}, {})

`````

Use selenium or cucumber

## Built With

- Python 3.9
- zpy cli

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see
the [tags on this repository](./CHANGELOG.md)
.

## Authors

- **@developer** - _[Backend Developer](@dev_url)_
"""
    },
    "requirements.txt": {
        "type": "file",
        "name": "requirements.txt",
        "content":
            """zpy-api-core~=1.0.12
python-dotenv~=0.19.1"""
    }
}
