"""item info

Revision ID: 21554d5b04b1
Revises: 
Create Date: 2025-03-17 11:17:21.919528

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import oracle

# revision identifiers, used by Alembic.
revision = '21554d5b04b1'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('DEALER_INFO',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('com_code', sa.Integer(), nullable=True),
    sa.Column('dealer_id', sa.Integer(), nullable=True),
    sa.Column('dealer_name', sa.String(length=255), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=True),
    sa.Column('owner_name', sa.String(length=255), nullable=True),
    sa.Column('allotted_address', sa.String(length=255), nullable=True),
    sa.Column('email', sa.String(length=255), nullable=True),
    sa.Column('contact1', sa.String(length=15), nullable=True),
    sa.Column('contact2', sa.String(length=15), nullable=True),
    sa.Column('remarks', sa.String(length=255), nullable=True),
    sa.Column('active_flag', sa.String(length=1), nullable=True),
    sa.Column('lock_flag', sa.String(length=1), nullable=True),
    sa.Column('created_by', sa.String(length=100), nullable=True),
    sa.Column('created_date', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('id_type', sa.String(length=50), nullable=True),
    sa.Column('id_no', sa.String(length=50), nullable=True),
    sa.Column('id_image1', sa.String(length=255), nullable=True),
    sa.Column('id_image2', sa.String(length=255), nullable=True),
    sa.Column('profile_image', sa.String(length=255), nullable=True),
    sa.Column('agent_code', sa.String(length=50), nullable=True),
    sa.Column('dealer_agent', sa.String(length=100), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('ITEM_INFO',
    sa.Column('item_code', sa.Integer(), nullable=False),
    sa.Column('item_id', sa.String(length=15), nullable=False),
    sa.Column('item_name', sa.String(length=200), nullable=False),
    sa.Column('item_description', sa.String(length=1000), nullable=True),
    sa.Column('base_unit', sa.String(length=5), nullable=True),
    sa.Column('transaction_unit', sa.String(length=5), nullable=True),
    sa.Column('category_id', sa.String(length=2), nullable=True),
    sa.Column('dimensions', sa.String(length=10), nullable=True),
    sa.Column('fractional_value', sa.Float(), nullable=True),
    sa.Column('parent_item_code', sa.String(length=30), nullable=False),
    sa.Column('grand_parent_item_code', sa.String(length=30), nullable=False),
    sa.Column('image_filename', sa.String(length=1000), nullable=True),
    sa.Column('shelf_life_in_days', sa.Integer(), nullable=True),
    sa.Column('max_inventory_level', sa.Float(), nullable=True),
    sa.Column('min_inventory_level', sa.Float(), nullable=True),
    sa.Column('preferred_inventory_level', sa.Float(), nullable=True),
    sa.Column('reorder_inventory_level', sa.Float(), nullable=True),
    sa.Column('danger_inventory_level', sa.Float(), nullable=True),
    sa.Column('economy_order_quantity', sa.Float(), nullable=True),
    sa.Column('preferred_vendor_code', sa.String(length=30), nullable=True),
    sa.Column('lead_time_in_days', sa.Integer(), nullable=True),
    sa.Column('average_rate', sa.Float(), nullable=True),
    sa.Column('current_landed_cost', sa.Float(), nullable=True),
    sa.Column('current_sales_price', sa.Float(), nullable=True),
    sa.Column('default_wip_inventory', sa.Float(), nullable=True),
    sa.Column('valuation_method_flag', sa.String(length=1), nullable=True),
    sa.Column('group_flag', sa.String(length=1), nullable=True),
    sa.Column('serial_code', sa.String(length=30), nullable=True),
    sa.Column('service_product_flag', sa.String(length=1), nullable=True),
    sa.Column('vehicle_transport_flag', sa.String(length=1), nullable=True),
    sa.Column('sr_transport_flag', sa.String(length=1), nullable=True),
    sa.Column('bt_transport_flag', sa.String(length=1), nullable=True),
    sa.Column('bt_sr_transport_flag', sa.String(length=1), nullable=True),
    sa.Column('warranty_flag', sa.String(length=1), nullable=True),
    sa.Column('manufacturing_capacity', sa.Integer(), nullable=True),
    sa.Column('manufacturing_expiry_date', sa.Integer(), nullable=True),
    sa.Column('ownership_flag', sa.String(length=3), nullable=True),
    sa.Column('non_moveable_flag', sa.String(length=1), nullable=True),
    sa.Column('expiry_flag', sa.String(length=1), nullable=True),
    sa.Column('company_code', sa.String(length=30), nullable=False),
    sa.Column('brand_code', sa.String(length=6), nullable=True),
    sa.Column('gsku_flag', sa.String(length=1), nullable=True),
    sa.Column('manufacturer_uid', sa.String(length=30), nullable=True),
    sa.Column('manufacture_date', sa.Date(), nullable=True),
    sa.Column('modified_by_uid', sa.String(length=30), nullable=True),
    sa.Column('modified_date', sa.Date(), nullable=True),
    sa.Column('valuation_flag', sa.String(length=1), nullable=True),
    sa.Column('remarks', sa.String(length=200), nullable=True),
    sa.Column('secondary_remarks', sa.String(length=200), nullable=True),
    sa.Column('min_sales_value', sa.Float(), nullable=True),
    sa.Column('max_sales_value', sa.Float(), nullable=True),
    sa.Column('sr_prefix_text', sa.String(length=3), nullable=True),
    sa.Column('sr_prefix_length', sa.Integer(), nullable=True),
    sa.Column('transaction_lock_flag', sa.String(length=1), nullable=True),
    sa.Column('opening_account_code', sa.String(length=30), nullable=True),
    sa.Column('reem_weight_kg', sa.Float(), nullable=True),
    sa.Column('item_brand_name', sa.String(length=30), nullable=True),
    sa.Column('company_name', sa.String(length=30), nullable=True),
    sa.Column('technical_specifications', sa.String(length=200), nullable=True),
    sa.Column('serial_number', sa.String(length=30), nullable=True),
    sa.Column('part_number', sa.String(length=30), nullable=True),
    sa.Column('model_number', sa.String(length=30), nullable=True),
    sa.Column('equipment_id', sa.String(length=30), nullable=True),
    sa.Column('item_size', sa.String(length=30), nullable=True),
    sa.Column('item_type', sa.String(length=20), nullable=True),
    sa.Column('item_gsm', sa.String(length=30), nullable=True),
    sa.Column('item_length', sa.String(length=30), nullable=True),
    sa.Column('item_width', sa.String(length=30), nullable=True),
    sa.Column('item_weight', sa.String(length=30), nullable=True),
    sa.Column('item_grade', sa.String(length=30), nullable=True),
    sa.Column('lamination_type', sa.String(length=30), nullable=True),
    sa.Column('item_thickness', sa.String(length=30), nullable=True),
    sa.Column('plant_id', sa.String(length=30), nullable=True),
    sa.Column('tech_specifications', sa.String(length=200), nullable=True),
    sa.Column('recycled_uid', sa.String(length=30), nullable=True),
    sa.Column('recycled_date', sa.Date(), nullable=True),
    sa.Column('recycled_flag', sa.String(length=1), nullable=True),
    sa.Column('previous_rate', sa.Float(), nullable=True),
    sa.Column('item_interface', sa.String(length=30), nullable=True),
    sa.Column('item_color', sa.String(length=20), nullable=True),
    sa.Column('item_shape', sa.String(length=50), nullable=True),
    sa.Column('preferred_customer_code', sa.String(length=30), nullable=True),
    sa.Column('hs_code', sa.String(length=20), nullable=True),
    sa.Column('critical_stock_level', sa.Integer(), nullable=True),
    sa.Column('purchase_account_code', sa.String(length=30), nullable=True),
    sa.Column('sales_account_code', sa.String(length=30), nullable=True),
    sa.Column('inventory_account_code', sa.String(length=30), nullable=True),
    sa.Column('transfer_account_code', sa.String(length=30), nullable=True),
    sa.Column('brand_account_code', sa.String(length=30), nullable=True),
    sa.Column('goods_receipt_account_code', sa.String(length=30), nullable=True),
    sa.Column('group_code', sa.String(length=30), nullable=True),
    sa.Column('warranty_period_days', sa.Integer(), nullable=True),
    sa.Column('bundle_flag', sa.String(length=1), nullable=True),
    sa.Column('sub_category_id', sa.Integer(), nullable=True),
    sa.Column('saudable_item_flag', sa.String(length=1), nullable=True),
    sa.Column('weight_gain_flag', sa.String(length=1), nullable=True),
    sa.Column('corrosion_flag', sa.String(length=1), nullable=True),
    sa.Column('rate_difference_flag', sa.String(length=1), nullable=True),
    sa.Column('fabric_flag', sa.String(length=1), nullable=True),
    sa.Column('batch_flag', sa.String(length=1), nullable=True),
    sa.Column('inward_quantity', sa.Integer(), nullable=True),
    sa.Column('inward_rate', sa.Float(), nullable=True),
    sa.Column('consumption_quantity', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('item_code')
    )
    op.create_table('PRODUCTDETAILS',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('product_code', sa.String(length=255), nullable=True),
    sa.Column('product_name', sa.String(length=255), nullable=True),
    sa.Column('product_description', sa.String(length=255), nullable=True),
    sa.Column('brand', sa.String(length=255), nullable=True),
    sa.Column('category_id', sa.Integer(), nullable=False),
    sa.Column('sku', sa.String(length=255), nullable=True),
    sa.Column('size', sa.String(length=50), nullable=True),
    sa.Column('color', sa.String(length=50), nullable=True),
    sa.Column('origin', sa.String(length=100), nullable=True),
    sa.Column('price', sa.DECIMAL(precision=10, scale=2), nullable=True),
    sa.Column('com_code', sa.String(length=100), nullable=True),
    sa.Column('sn_no', sa.String(length=100), nullable=False),
    sa.Column('hot_product', sa.Boolean(), nullable=True),
    sa.Column('featured_product', sa.Boolean(), nullable=True),
    sa.Column('product_show_flag', sa.Boolean(), nullable=True),
    sa.Column('product_lock_flag', sa.Boolean(), nullable=True),
    sa.Column('seo_keywords', sa.String(length=255), nullable=True),
    sa.Column('seo_description', sa.String(length=255), nullable=True),
    sa.Column('no_of_views', sa.Integer(), nullable=True),
    sa.Column('video_url_1', sa.String(length=255), nullable=True),
    sa.Column('video_url_2', sa.String(length=255), nullable=True),
    sa.Column('video_url_3', sa.String(length=255), nullable=True),
    sa.Column('recycled_flag', sa.String(length=1), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('PRODUCTS',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('product_code', sa.String(length=255), nullable=True),
    sa.Column('product_name', sa.String(length=255), nullable=True),
    sa.Column('product_description', sa.String(length=255), nullable=True),
    sa.Column('brand', sa.String(length=255), nullable=True),
    sa.Column('category_id', sa.Integer(), nullable=True),
    sa.Column('size', sa.String(length=50), nullable=True),
    sa.Column('color', sa.String(length=50), nullable=True),
    sa.Column('origin', sa.String(length=100), nullable=True),
    sa.Column('price', sa.DECIMAL(precision=10, scale=2), nullable=True),
    sa.Column('com_code', sa.String(length=100), nullable=True),
    sa.Column('hot_product', sa.String(length=1), nullable=True),
    sa.Column('featured_product', sa.String(length=1), nullable=True),
    sa.Column('product_show_flag', sa.String(length=1), nullable=True),
    sa.Column('product_lock_flag', sa.String(length=1), nullable=True),
    sa.Column('seo_keywords', sa.String(length=255), nullable=True),
    sa.Column('seo_description', sa.String(length=255), nullable=True),
    sa.Column('no_of_views', sa.Integer(), nullable=True),
    sa.Column('video_url_1', sa.String(length=255), nullable=True),
    sa.Column('video_url_2', sa.String(length=255), nullable=True),
    sa.Column('video_url_3', sa.String(length=255), nullable=True),
    sa.Column('recycled_flag', sa.String(length=1), nullable=True),
    sa.Column('created_by', sa.String(length=100), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('STORE_INFO',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('com_code', sa.Integer(), nullable=True),
    sa.Column('shop_name', sa.String(length=255), nullable=True),
    sa.Column('display_name', sa.String(length=255), nullable=True),
    sa.Column('pan_number', sa.String(length=20), nullable=True),
    sa.Column('shop_description', sa.String(length=255), nullable=True),
    sa.Column('owner_name', sa.String(length=100), nullable=True),
    sa.Column('contact_person_name', sa.String(length=100), nullable=True),
    sa.Column('contact_person_mobile', sa.String(length=15), nullable=True),
    sa.Column('contact_email', sa.String(length=100), nullable=True),
    sa.Column('phone_number', sa.String(length=15), nullable=True),
    sa.Column('mobile_number', sa.String(length=15), nullable=True),
    sa.Column('whatsapp_number', sa.String(length=15), nullable=True),
    sa.Column('city', sa.String(length=100), nullable=True),
    sa.Column('postal_code', sa.String(length=20), nullable=True),
    sa.Column('country', sa.String(length=100), nullable=True),
    sa.Column('municipality', sa.String(length=100), nullable=True),
    sa.Column('landmark', sa.String(length=255), nullable=True),
    sa.Column('latitude', sa.String(length=255), nullable=True),
    sa.Column('longitude', sa.String(length=255), nullable=True),
    sa.Column('website_url', sa.String(length=255), nullable=True),
    sa.Column('social_media_links', sa.String(length=255), nullable=True),
    sa.Column('seo_keywords', sa.String(length=255), nullable=True),
    sa.Column('opening_hours', sa.String(length=100), nullable=True),
    sa.Column('shop_type', sa.String(length=50), nullable=True),
    sa.Column('service_area', sa.String(length=255), nullable=True),
    sa.Column('business_category', sa.String(length=50), nullable=True),
    sa.Column('post_content', sa.String(length=4000), nullable=True),
    sa.Column('show_flag', sa.String(length=1), nullable=True),
    sa.Column('lock_flag', sa.String(length=1), nullable=True),
    sa.Column('verified_flag', sa.String(length=1), nullable=True),
    sa.Column('verified_suppliers_flag', sa.String(length=1), nullable=True),
    sa.Column('established_date', sa.Date(), nullable=True),
    sa.Column('dealing_brands', sa.String(length=255), nullable=True),
    sa.Column('business_logo', sa.String(length=255), nullable=True),
    sa.Column('shop_cover_photo', sa.String(length=255), nullable=True),
    sa.Column('thumbnail', sa.String(length=255), nullable=True),
    sa.Column('youtube_ad', sa.String(length=255), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('create_by', sa.Integer(), nullable=True),
    sa.Column('update_by', sa.Integer(), nullable=True),
    sa.Column('dealer_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('productdetails')
    op.drop_table('dealer_info')
    op.drop_table('products')
    op.drop_table('store_info')
    op.drop_table('item_info')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('item_info',
    sa.Column('item_code', sa.VARCHAR(length=30), nullable=False),
    sa.Column('item_id', sa.VARCHAR(length=15), nullable=False),
    sa.Column('item_name', sa.VARCHAR(length=200), nullable=False),
    sa.Column('item_description', sa.VARCHAR(length=1000), nullable=True),
    sa.Column('base_unit', sa.VARCHAR(length=5), nullable=True),
    sa.Column('transaction_unit', sa.VARCHAR(length=5), nullable=True),
    sa.Column('category_id', sa.VARCHAR(length=2), nullable=True),
    sa.Column('dimensions', sa.VARCHAR(length=10), nullable=True),
    sa.Column('fractional_value', sa.FLOAT(), nullable=True),
    sa.Column('parent_item_code', sa.VARCHAR(length=30), nullable=False),
    sa.Column('grand_parent_item_code', sa.VARCHAR(length=30), nullable=False),
    sa.Column('image_filename', sa.VARCHAR(length=1000), nullable=True),
    sa.Column('shelf_life_in_days', sa.INTEGER(), nullable=True),
    sa.Column('max_inventory_level', sa.FLOAT(), nullable=True),
    sa.Column('min_inventory_level', sa.FLOAT(), nullable=True),
    sa.Column('preferred_inventory_level', sa.FLOAT(), nullable=True),
    sa.Column('reorder_inventory_level', sa.FLOAT(), nullable=True),
    sa.Column('danger_inventory_level', sa.FLOAT(), nullable=True),
    sa.Column('economy_order_quantity', sa.FLOAT(), nullable=True),
    sa.Column('preferred_vendor_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('lead_time_in_days', sa.INTEGER(), nullable=True),
    sa.Column('average_rate', sa.FLOAT(), nullable=True),
    sa.Column('current_landed_cost', sa.FLOAT(), nullable=True),
    sa.Column('current_sales_price', sa.FLOAT(), nullable=True),
    sa.Column('default_wip_inventory', sa.FLOAT(), nullable=True),
    sa.Column('valuation_method_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('group_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('serial_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('service_product_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('vehicle_transport_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('sr_transport_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('bt_transport_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('bt_sr_transport_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('warranty_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('manufacturing_capacity', sa.INTEGER(), nullable=True),
    sa.Column('manufacturing_expiry_date', sa.INTEGER(), nullable=True),
    sa.Column('ownership_flag', sa.VARCHAR(length=3), nullable=True),
    sa.Column('non_moveable_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('expiry_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('company_code', sa.VARCHAR(length=30), nullable=False),
    sa.Column('brand_code', sa.VARCHAR(length=6), nullable=True),
    sa.Column('gsku_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('manufacturer_uid', sa.VARCHAR(length=30), nullable=True),
    sa.Column('manufacture_date', oracle.DATE(), nullable=True),
    sa.Column('modified_by_uid', sa.VARCHAR(length=30), nullable=True),
    sa.Column('modified_date', oracle.DATE(), nullable=True),
    sa.Column('valuation_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('remarks', sa.VARCHAR(length=200), nullable=True),
    sa.Column('secondary_remarks', sa.VARCHAR(length=200), nullable=True),
    sa.Column('min_sales_value', sa.FLOAT(), nullable=True),
    sa.Column('max_sales_value', sa.FLOAT(), nullable=True),
    sa.Column('sr_prefix_text', sa.VARCHAR(length=3), nullable=True),
    sa.Column('sr_prefix_length', sa.INTEGER(), nullable=True),
    sa.Column('transaction_lock_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('opening_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('reem_weight_kg', sa.FLOAT(), nullable=True),
    sa.Column('item_brand_name', sa.VARCHAR(length=30), nullable=True),
    sa.Column('company_name', sa.VARCHAR(length=30), nullable=True),
    sa.Column('technical_specifications', sa.VARCHAR(length=200), nullable=True),
    sa.Column('serial_number', sa.VARCHAR(length=30), nullable=True),
    sa.Column('part_number', sa.VARCHAR(length=30), nullable=True),
    sa.Column('model_number', sa.VARCHAR(length=30), nullable=True),
    sa.Column('equipment_id', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_size', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_type', sa.VARCHAR(length=20), nullable=True),
    sa.Column('item_gsm', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_length', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_width', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_weight', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_grade', sa.VARCHAR(length=30), nullable=True),
    sa.Column('lamination_type', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_thickness', sa.VARCHAR(length=30), nullable=True),
    sa.Column('plant_id', sa.VARCHAR(length=30), nullable=True),
    sa.Column('tech_specifications', sa.VARCHAR(length=200), nullable=True),
    sa.Column('recycled_uid', sa.VARCHAR(length=30), nullable=True),
    sa.Column('recycled_date', oracle.DATE(), nullable=True),
    sa.Column('recycled_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('previous_rate', sa.FLOAT(), nullable=True),
    sa.Column('item_interface', sa.VARCHAR(length=30), nullable=True),
    sa.Column('item_color', sa.VARCHAR(length=20), nullable=True),
    sa.Column('item_shape', sa.VARCHAR(length=50), nullable=True),
    sa.Column('preferred_customer_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('hs_code', sa.VARCHAR(length=20), nullable=True),
    sa.Column('critical_stock_level', sa.INTEGER(), nullable=True),
    sa.Column('purchase_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('sales_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('inventory_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('transfer_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('brand_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('goods_receipt_account_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('group_code', sa.VARCHAR(length=30), nullable=True),
    sa.Column('warranty_period_days', sa.INTEGER(), nullable=True),
    sa.Column('bundle_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('sub_category_id', sa.INTEGER(), nullable=True),
    sa.Column('saudable_item_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('weight_gain_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('corrosion_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('rate_difference_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('fabric_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('batch_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('inward_quantity', sa.INTEGER(), nullable=True),
    sa.Column('inward_rate', sa.FLOAT(), nullable=True),
    sa.Column('consumption_quantity', sa.INTEGER(), nullable=True),
    sa.PrimaryKeyConstraint('item_code', name='sys_c0012452')
    )
    op.create_table('store_info',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('com_code', sa.INTEGER(), nullable=True),
    sa.Column('shop_name', sa.VARCHAR(length=255), nullable=True),
    sa.Column('display_name', sa.VARCHAR(length=255), nullable=True),
    sa.Column('pan_number', sa.VARCHAR(length=20), nullable=True),
    sa.Column('shop_description', sa.VARCHAR(length=255), nullable=True),
    sa.Column('owner_name', sa.VARCHAR(length=100), nullable=True),
    sa.Column('contact_person_name', sa.VARCHAR(length=100), nullable=True),
    sa.Column('contact_person_mobile', sa.VARCHAR(length=15), nullable=True),
    sa.Column('contact_email', sa.VARCHAR(length=100), nullable=True),
    sa.Column('phone_number', sa.VARCHAR(length=15), nullable=True),
    sa.Column('mobile_number', sa.VARCHAR(length=15), nullable=True),
    sa.Column('whatsapp_number', sa.VARCHAR(length=15), nullable=True),
    sa.Column('city', sa.VARCHAR(length=100), nullable=True),
    sa.Column('postal_code', sa.VARCHAR(length=20), nullable=True),
    sa.Column('country', sa.VARCHAR(length=100), nullable=True),
    sa.Column('municipality', sa.VARCHAR(length=100), nullable=True),
    sa.Column('landmark', sa.VARCHAR(length=255), nullable=True),
    sa.Column('latitude', sa.VARCHAR(length=255), nullable=True),
    sa.Column('longitude', sa.VARCHAR(length=255), nullable=True),
    sa.Column('website_url', sa.VARCHAR(length=255), nullable=True),
    sa.Column('social_media_links', sa.VARCHAR(length=255), nullable=True),
    sa.Column('seo_keywords', sa.VARCHAR(length=255), nullable=True),
    sa.Column('opening_hours', sa.VARCHAR(length=100), nullable=True),
    sa.Column('shop_type', sa.VARCHAR(length=50), nullable=True),
    sa.Column('service_area', sa.VARCHAR(length=255), nullable=True),
    sa.Column('business_category', sa.VARCHAR(length=50), nullable=True),
    sa.Column('post_content', sa.VARCHAR(length=4000), nullable=True),
    sa.Column('show_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('lock_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('verified_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('verified_suppliers_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('established_date', oracle.DATE(), nullable=True),
    sa.Column('dealing_brands', sa.VARCHAR(length=255), nullable=True),
    sa.Column('business_logo', sa.VARCHAR(length=255), nullable=True),
    sa.Column('shop_cover_photo', sa.VARCHAR(length=255), nullable=True),
    sa.Column('thumbnail', sa.VARCHAR(length=255), nullable=True),
    sa.Column('youtube_ad', sa.VARCHAR(length=255), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('create_by', sa.INTEGER(), nullable=True),
    sa.Column('update_by', sa.INTEGER(), nullable=True),
    sa.Column('dealer_id', sa.INTEGER(), nullable=True),
    sa.PrimaryKeyConstraint('id', name='sys_c0012294')
    )
    op.create_table('products',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('product_code', sa.VARCHAR(length=255), nullable=True),
    sa.Column('product_name', sa.VARCHAR(length=255), nullable=True),
    sa.Column('product_description', sa.VARCHAR(length=255), nullable=True),
    sa.Column('brand', sa.VARCHAR(length=255), nullable=True),
    sa.Column('category_id', sa.INTEGER(), nullable=True),
    sa.Column('size', sa.VARCHAR(length=50), nullable=True),
    sa.Column('color', sa.VARCHAR(length=50), nullable=True),
    sa.Column('origin', sa.VARCHAR(length=100), nullable=True),
    sa.Column('price', oracle.NUMBER(precision=10, scale=2, asdecimal=True), nullable=True),
    sa.Column('com_code', sa.VARCHAR(length=100), nullable=True),
    sa.Column('hot_product', sa.VARCHAR(length=1), nullable=True),
    sa.Column('featured_product', sa.VARCHAR(length=1), nullable=True),
    sa.Column('product_show_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('product_lock_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('seo_keywords', sa.VARCHAR(length=255), nullable=True),
    sa.Column('seo_description', sa.VARCHAR(length=255), nullable=True),
    sa.Column('no_of_views', sa.INTEGER(), nullable=True),
    sa.Column('video_url_1', sa.VARCHAR(length=255), nullable=True),
    sa.Column('video_url_2', sa.VARCHAR(length=255), nullable=True),
    sa.Column('video_url_3', sa.VARCHAR(length=255), nullable=True),
    sa.Column('recycled_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('created_by', sa.VARCHAR(length=100), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.PrimaryKeyConstraint('id', name='sys_c0012298')
    )
    op.create_table('dealer_info',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('com_code', sa.INTEGER(), nullable=True),
    sa.Column('dealer_id', sa.INTEGER(), nullable=True),
    sa.Column('dealer_name', sa.VARCHAR(length=255), nullable=True),
    sa.Column('address', sa.VARCHAR(length=255), nullable=True),
    sa.Column('owner_name', sa.VARCHAR(length=255), nullable=True),
    sa.Column('allotted_address', sa.VARCHAR(length=255), nullable=True),
    sa.Column('email', sa.VARCHAR(length=255), nullable=True),
    sa.Column('contact1', sa.VARCHAR(length=15), nullable=True),
    sa.Column('contact2', sa.VARCHAR(length=15), nullable=True),
    sa.Column('remarks', sa.VARCHAR(length=255), nullable=True),
    sa.Column('active_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('lock_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('created_by', sa.VARCHAR(length=100), nullable=True),
    sa.Column('created_date', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('id_type', sa.VARCHAR(length=50), nullable=True),
    sa.Column('id_no', sa.VARCHAR(length=50), nullable=True),
    sa.Column('id_image1', sa.VARCHAR(length=255), nullable=True),
    sa.Column('id_image2', sa.VARCHAR(length=255), nullable=True),
    sa.Column('profile_image', sa.VARCHAR(length=255), nullable=True),
    sa.Column('agent_code', sa.VARCHAR(length=50), nullable=True),
    sa.Column('dealer_agent', sa.VARCHAR(length=100), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.PrimaryKeyConstraint('id', name='sys_c0012296')
    )
    op.create_table('productdetails',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('product_code', sa.VARCHAR(length=255), nullable=True),
    sa.Column('product_name', sa.VARCHAR(length=255), nullable=True),
    sa.Column('product_description', sa.VARCHAR(length=255), nullable=True),
    sa.Column('brand', sa.VARCHAR(length=255), nullable=True),
    sa.Column('category_id', sa.INTEGER(), nullable=False),
    sa.Column('sku', sa.VARCHAR(length=255), nullable=True),
    sa.Column('size', sa.VARCHAR(length=50), nullable=True),
    sa.Column('color', sa.VARCHAR(length=50), nullable=True),
    sa.Column('origin', sa.VARCHAR(length=100), nullable=True),
    sa.Column('price', oracle.NUMBER(precision=10, scale=2, asdecimal=True), nullable=True),
    sa.Column('com_code', sa.VARCHAR(length=100), nullable=True),
    sa.Column('sn_no', sa.VARCHAR(length=100), nullable=False),
    sa.Column('hot_product', sa.INTEGER(), nullable=True),
    sa.Column('featured_product', sa.INTEGER(), nullable=True),
    sa.Column('product_show_flag', sa.INTEGER(), nullable=True),
    sa.Column('product_lock_flag', sa.INTEGER(), nullable=True),
    sa.Column('seo_keywords', sa.VARCHAR(length=255), nullable=True),
    sa.Column('seo_description', sa.VARCHAR(length=255), nullable=True),
    sa.Column('no_of_views', sa.INTEGER(), nullable=True),
    sa.Column('video_url_1', sa.VARCHAR(length=255), nullable=True),
    sa.Column('video_url_2', sa.VARCHAR(length=255), nullable=True),
    sa.Column('video_url_3', sa.VARCHAR(length=255), nullable=True),
    sa.Column('recycled_flag', sa.VARCHAR(length=1), nullable=True),
    sa.Column('created_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(), server_default=sa.text('CURRENT_TIMESTAMP'), nullable=True),
    sa.PrimaryKeyConstraint('id', name='sys_c0012302')
    )
    op.drop_table('STORE_INFO')
    op.drop_table('PRODUCTS')
    op.drop_table('PRODUCTDETAILS')
    op.drop_table('ITEM_INFO')
    op.drop_table('DEALER_INFO')
    # ### end Alembic commands ###
