from flask import Blueprint, render_template, jsonify, request,url_for,send_from_directory
from flask_jwt_extended import create_access_token, jwt_required,get_jwt_identity
from . import db
from .models import *  # Import your models
from datetime import timedelta, datetime
import os
import json
from werkzeug.utils import secure_filename

main = Blueprint('main', __name__)

users = {
    "admin": "admin",
    "user2": "password2"
}


def select_images(folder_path):
    images = []
    if os.path.exists(folder_path):
        for filename in os.listdir(folder_path):
            if filename.endswith((".jpg", ".jpeg", ".png")):
                images.append(os.path.join(folder_path, filename))
    else:
        print(f"Folder '{folder_path}' not found.")
    return images
def get_image_urls(folder_path, server_ip, port,folder_path_des):
    images = []
    print(folder_path)
    if os.path.exists(folder_path):
        for filename in os.listdir(folder_path):
            if filename.endswith((".jpg", ".jpeg", ".png", ".pdf",".xlsx")):
                image_path = os.path.join(folder_path, filename)
                image_url = f"http://{server_ip}:{port}/{folder_path_des}/{filename}"
                print(image_url)
                print('iiiiiiiiiiiiiiii')
                images.append(image_url)
    else:
        #print(f"Folder '{folder_path}' not found.")
        pass
    return images

@main.route('/')
def index():
    # Example: query the database for store information
    server_ip = "127.0.0.1"
    # Assuming 'server_port' contains the port number of your server
    server_port = "5000"
    APP_ROOT = os.path.dirname(os.path.abspath(__file__))
    #UPLOAD_FOLDER = os.path.join(APP_ROOT, 'static', 'images','attachments','store_info')  # Specify the correct path here
    #main.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
#     qry = """
#     SELECT `id`, `com_code`, `display_name`, `municipality`,`city`,`shop_type`, `thumbnail`
# FROM `store_info`
#     """
    qry = """
            SELECT  id ,  com_code,  display_name , municipality , city,shop_type, thumbnail
            FROM  store_info where id<7
        """
    #res_record = db.session.execute(qry).fetchall()  # Fetch all results from the DB
    voucher = db.session.execute(qry).fetchall()
    arr=[]
    for i in voucher:
        data={}
        data['id']=i[0]
        data['com_code']=i[1]
        data['display_name']=i[2]
        data['municipality']=i[3]
        data['city']=i[4]
        data['shop_type']=i[5]
        
        folder_path = os.path.join(APP_ROOT,'static', 'images', 'attachments','store_info')
        folder_path_des = os.path.join('static', 'images', 'attachments','store_info')
        data['img_urls'] = get_image_urls(folder_path, server_ip, server_port,folder_path_des)
        arr.append(data)
    #all_val = json.dumps(arr)
    #return jsonify(arr)
    # Pass the stores with URLs to the template
    print(arr)
    return render_template('index.html', res_record=arr)
@main.route('/storex/<int:store_id>', methods=['GET'])
def show_storex(store_id):
    # Example: query the database for store information
    print(store_id)
    server_ip = "127.0.0.1"
    # Assuming 'server_port' contains the port number of your server
    server_port = "5000"
    APP_ROOT = os.path.dirname(os.path.abspath(__file__))
    #UPLOAD_FOLDER = os.path.join(APP_ROOT, 'static', 'images','attachments','store_info')  # Specify the correct path here
    #main.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
#     qry = """
#     SELECT `id`, `com_code`, `display_name`, `municipality`,`city`,`shop_type`, `thumbnail`
# FROM `store_info`
# WHERE id=store_id
#     """
    qry = ""
    #res_record = db.session.execute(qry).fetchall()  # Fetch all results from the DB
    voucher = db.session.execute(qry).fetchall()
    arr=[]
    for i in voucher:
        data={}
        data['id']=i[0]
        data['com_code']=i[1]
        data['display_name']=i[2]
        data['municipality']=i[3]
        data['city']=i[4]
        data['shop_type']=i[5]
        
        folder_path = os.path.join(APP_ROOT,'static', 'images', 'attachments','store_info')
        folder_path_des = os.path.join('static', 'images', 'attachments','store_info')
        data['img_urls'] = get_image_urls(folder_path, server_ip, server_port,folder_path_des)
        arr.append(data)
    #all_val = json.dumps(arr)
    #return jsonify(arr)
    # Pass the stores with URLs to the template
    print(arr)
    return render_template('store.html', res_record=arr)

@main.route('/store/<int:store_id>', methods=['GET'])
def show_store(store_id):
    # Example: print store_id for debugging
    print(f"Store ID: {store_id}")
    
    server_ip = "127.0.0.1"
    server_port = "5000"
    APP_ROOT = os.path.dirname(os.path.abspath(__file__))
    
    # SQL Query (Parameterization for security)
    # qry = """
    # SELECT `id`, `com_code`, `display_name`, `municipality`, `city`, `shop_type`, `thumbnail`,shop_description
    # FROM `store_info`
    # WHERE id = :store_id
    # """
    qry = ""
    voucher = db.session.execute(qry, {'store_id': store_id}).fetchall()

    arr = []
    for i in voucher:
        data = {
            'id': i[0],
            'com_code': i[1],
            'display_name': i[2],
            'municipality': i[3],
            'city': i[4],
            'shop_type': i[5],
            'shop_description':i[7]
        }

        # Handle image paths and URLs
        folder_path = os.path.join(APP_ROOT, 'static', 'images', 'attachments', 'store_info')
        folder_path_des = os.path.join('static', 'images', 'attachments', 'store_info')
        data['img_urls'] = get_image_urls(folder_path, server_ip, server_port, folder_path_des)

        arr.append(data)
    
    # Debug: print the array of store data
    print(arr)

    # Pass the store data to the template
    return render_template('store.html', res_record=arr)
@main.route('/search_result/<search_key>', methods=['GET'])
def search_result(search_key):
    # Example: print store_id for debugging
    print(f"search_key ID: {search_key}")
    
    server_ip = "127.0.0.1"
    server_port = "5000"
    APP_ROOT = os.path.dirname(os.path.abspath(__file__))
    
    # SQL Query (Parameterization for security)
    qry = f"""
    SELECT `id`, `com_code`, `display_name`, `municipality`, `city`, `shop_type`, `thumbnail`
    FROM `store_info`
    WHERE display_name like '%{search_key}%'
    """
    voucher = db.session.execute(qry).fetchall()

    arr = []
    for i in voucher:
        data = {
            'id': i[0],
            'com_code': i[1],
            'display_name': i[2],
            'municipality': i[3],
            'city': i[4],
            'shop_type': i[5]
        }

        # Handle image paths and URLs
        folder_path = os.path.join(APP_ROOT, 'static', 'images', 'attachments', 'store_info')
        folder_path_des = os.path.join('static', 'images', 'attachments', 'store_info')
        data['img_urls'] = get_image_urls(folder_path, server_ip, server_port, folder_path_des)

        arr.append(data)
    
    # Debug: print the array of store data
    print(arr)

    # Pass the store data to the template
    return render_template('search_results.html', res_record=arr)
@main.route('/lpage')
def lpage():
    return render_template('login.html')

@main.route('/login', methods=['POST'])
def login():
    # Get the JSON data from the request
    data = request.get_json()
    print(data)
    # Extract username (login_name) and password from the request data
    login_name = data.get('username')
    password = data.get('password')

    # Query the User model to find a user with the given login_name
    user = User.query.filter_by(login_name=login_name).first()

    # Check if the user exists and the password matches
    if user and user.password == password:  # Make sure to hash passwords in production
        # Create a dictionary of user fields, excluding private attributes
        user_data = {key: value for key, value in user.__dict__.items() if not key.startswith('_')}

        # Create the JWT token with user data
        expires_delta = timedelta(days=365000)
        access_token = create_access_token(identity=user_data,expires_delta=expires_delta)
        print(access_token)

        return jsonify(access_token=access_token), 200

    return jsonify({"msg": "Bad username or password"}), 401
@main.route('/master_group', methods=['POST','GET'])
@jwt_required()
def master_group():
    # Query only the 'code' and 'name' columns from the Master table
    masters = Master.query.with_entities(Master.code, Master.name).all()

    if masters:
        # Create a list of dictionaries for each master record
        res_data = [{'code': master.code, 'name': master.name} for master in masters]

        return jsonify(res_data), 200

    return jsonify({"msg": "No records found"}), 404

@main.route('/ac_master', methods=['POST', 'GET'])
@jwt_required()
def ac_master():
    # Get the identity from the JWT
    current_user = get_jwt_identity()
    
    # Assuming 'com_code' is part of the user data in the JWT
    com_code_value = current_user.get('com_code')  # Adjust key based on your JWT payload

    if com_code_value is None:
        return jsonify({"msg": "com_code not found in token"}), 400
    print(com_code_value)

    # Query only the 'code', 'name', and 'abr' columns from the GL table
    #masters = GL.query(GL.ac_code, GL.ac_name, GL.ac_abr).filter(GL.com_code == com_code_value).all()
    #masters = GL.query.with_entities(GL.ac_code, GL.ac_name, GL.ac_abr).filter(GL.com_code == com_code_value).all()
    masters = GL.query.with_entities(GL.ac_code, GL.ac_name, GL.ac_abr) \
    .filter((GL.com_code == com_code_value) | (GL.com_code == 0)) \
    .all()



    if masters:
        # Create a list of dictionaries for each master record
        res_data = [{'ac_code': master.ac_code, 'ac_name': master.ac_name, 'abr': master.ac_abr} for master in masters]

        return jsonify(res_data), 200

    return jsonify({"msg": "No records found"}), 404

@main.route('/gl', methods=['POST'])
@jwt_required()
def create_gl():
    data = request.get_json()
    print(data)

    # Get the identity from the JWT token
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')

    # Validate input data
    required_fields = ['acGroup', 'ac_name']
    if not all(field in data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    # Get the maximum gl_code from the database
    max_gl_code = db.session.query(db.func.max(GL.ac_code)).scalar()

    # Set the new gl_code
    new_gl_code = max_gl_code + 1 if max_gl_code is not None else 1

    new_gl = GL(
        master_code=data['acGroup'],
        ac_code=new_gl_code,  # Use calculated gl_code
        ac_abr=data['ac_abr'],
        ac_name=data.get('ac_name'),
        address=data.get('address'),
        contact1=data.get('contact1'),
        whatsapp=data.get('whatsapp'),
        contact2=data.get('contact2'),
        opening_dr=data.get('opening_dr', 0.00),
        opening_cr=data.get('opening_cr', 0.00),
        pan=data.get('pan', 0.00),
        com_code=com_code
    )

    db.session.add(new_gl)
    db.session.commit()

    return jsonify({"msg": "GL entry created", "gl_code": new_gl_code}), 201

@main.route('/sales_transactions', methods=['POST'])
@jwt_required()
def create_sales_transaction():
    # Get the identity from the JWT token
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')
    create_uid = current_user.get('username')

    # Check if the request content type is valid
    if 'multipart/form-data' not in request.content_type and 'application/json' not in request.content_type:
        return jsonify({"msg": "Unsupported media type"}), 415

    # Initialize form data
    form_data = {}
    
    # Parse JSON if content type is application/json
    if 'application/json' in request.content_type:
        form_data = request.json
    else:
        form_data = request.form

    # Validate input data
    required_fields = ['date', 'v_no', 'ac_code', 'transaction_type']
    if not all(field in form_data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    # Check and create attachments directory if it doesn't exist
    attachments_dir = 'attachments/'+com_code+'/Sales'+'/'+form_data['v_no']
    if not os.path.exists(attachments_dir):
        os.makedirs(attachments_dir)

    # Handle file upload if any
    attachment_file = request.files.get('attachment_file')
    attachment_path = None
    print(attachment_file)
    print('kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk file')
    if attachment_file:
        attachment_path = os.path.join(attachments_dir, attachment_file.filename)
        attachment_file.save(attachment_path)

    # Create a new transaction entry
    new_transaction = Transactions(
        date=form_data['date'],
        v_no=form_data['v_no'],
        com_code=com_code,
        ac_code=form_data['ac_code'],  # Sales
        transaction_type=form_data['transaction_type'],
        debit=form_data.get('debit', 0.00),
        credit=form_data.get('credit', 0.00),
        attachments=attachment_file,
        remarks=form_data.get('remarks'),
        next_followup=form_data.get('next_followup'),
        create_uid='bm'
    )

    db.session.add(new_transaction)
    db.session.commit()
    #Journal Voucher Sales
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=1,            # Serial number
    ac_code=form_data['ac_code'],        # Account code
    ac_id=789,          # Account ID
    descriptions = f'Sales Bill NO {form_data["v_no"]}',  # Transaction description
    dr_amount=form_data.get('amount', 0.00),   # Debit amount
    cr_amount=0.00,     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=2,            # Serial number
    ac_code=4,        # Account code for sales
    ac_id=4,          # Account ID
    descriptions = f'Sales Bill NO {form_data["v_no"]}',  # Transaction description # Transaction description
    dr_amount=0.00,   # Debit amount
    cr_amount=form_data.get('amount', 0.00),     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()

    return jsonify({"msg": "Transaction created", "transaction_id": new_transaction.id}), 201
@main.route('/purchase_transactions', methods=['POST'])
@jwt_required()
def purchase_transactions():
    # Get the identity from the JWT token
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')
    create_uid = current_user.get('username')

    # Check if the request content type is valid
    if 'multipart/form-data' not in request.content_type and 'application/json' not in request.content_type:
        return jsonify({"msg": "Unsupported media type"}), 415

    # Initialize form data
    form_data = {}
    
    # Parse JSON if content type is application/json
    if 'application/json' in request.content_type:
        form_data = request.json
    else:
        form_data = request.form

    # Validate input data
    required_fields = ['date', 'v_no', 'ac_code', 'transaction_type']
    if not all(field in form_data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    # Check and create attachments directory if it doesn't exist
    attachments_dir = 'attachments/'+com_code+'/Purchase'+'/'+form_data['v_no']
    if not os.path.exists(attachments_dir):
        os.makedirs(attachments_dir)

    # Handle file upload if any
    attachment_file = request.files.get('attachment_file')
    attachment_path = None
    print(attachment_file)
    print('kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk file')
    if attachment_file:
        attachment_path = os.path.join(attachments_dir, attachment_file.filename)
        attachment_file.save(attachment_path)

    # Create a new transaction entry
    new_transaction = Transactions(
        date=form_data['date'],
        v_no=form_data['v_no'],
        com_code=com_code,
        ac_code=form_data['ac_code'],  # Sales
        transaction_type=form_data['transaction_type'],
        debit=form_data.get('debit', 0.00),
        credit=form_data.get('credit', 0.00),
        attachments=attachment_file,
        remarks=form_data.get('remarks'),
        next_followup=form_data.get('next_followup'),
        create_uid='bm'
    )

    db.session.add(new_transaction)
    db.session.commit()
    #Journal Voucher Sales
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=1,            # Serial number
    ac_code=form_data['ac_code'],        # Account code
    ac_id=789,          # Account ID
    descriptions = f'Purchase Bill NO {form_data["v_no"]}',  # Transaction description
    dr_amount=form_data.get('amount', 0.00),   # Debit amount
    cr_amount=0.00,     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=2,            # Serial number
    ac_code=5,        # Account code for Purchase -5 
    ac_id=5,          # Account ID
    descriptions = f'Purchase Bill NO {form_data["v_no"]}',  # Transaction description # Transaction description
    dr_amount=0.00,   # Debit amount
    cr_amount=form_data.get('amount', 0.00),     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()

    return jsonify({"msg": "Transaction created", "transaction_id": new_transaction.id}), 201
@main.route('/receipt_transactions', methods=['POST'])
@jwt_required()
def receipt_transactions():
    # Get the identity from the JWT token
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')
    create_uid = current_user.get('username')

    # Check if the request content type is valid
    if 'multipart/form-data' not in request.content_type and 'application/json' not in request.content_type:
        return jsonify({"msg": "Unsupported media type"}), 415

    # Initialize form data
    form_data = {}
    
    # Parse JSON if content type is application/json
    if 'application/json' in request.content_type:
        form_data = request.json
    else:
        form_data = request.form

    # Validate input data
    required_fields = ['date', 'v_no', 'ac_code', 'transaction_type']
    if not all(field in form_data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    # Check and create attachments directory if it doesn't exist
    attachments_dir = 'attachments/'+com_code+'/Purchase'+'/'+form_data['v_no']
    if not os.path.exists(attachments_dir):
        os.makedirs(attachments_dir)

    # Handle file upload if any
    attachment_file = request.files.get('attachment_file')
    attachment_path = None
    print(attachment_file)
    print('kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk file')
    if attachment_file:
        attachment_path = os.path.join(attachments_dir, attachment_file.filename)
        attachment_file.save(attachment_path)

    # Create a new transaction entry
    new_transaction = Transactions(
        date=form_data['date'],
        v_no=form_data['v_no'],
        com_code=com_code,
        ac_code=form_data['ac_code'],  # Sales
        transaction_type=form_data['transaction_type'],
        debit=form_data.get('debit', 0.00),
        credit=form_data.get('credit', 0.00),
        attachments=attachment_file,
        remarks=form_data.get('remarks'),
        next_followup=form_data.get('next_followup'),
        create_uid='bm'
    )

    db.session.add(new_transaction)
    db.session.commit()
    #Journal Voucher Sales
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=1,            # Serial number
    ac_code=1,        # Account code 1 fro cash a/c
    ac_id=1,          # Account ID
    descriptions = f'Receipt V NO {form_data["v_no"]}',  # Transaction description
    dr_amount=form_data.get('amount', 0.00),   # Debit amount
    cr_amount=0.00,     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=2,            # Serial number
    ac_code=form_data['ac_code'],        # Account code for Purchase -5 
    ac_id=form_data['ac_code'],          # Account ID
    descriptions = f'Receipt V NO {form_data["v_no"]}',  # Transaction description # Transaction description
    dr_amount=0.00,   # Debit amount
    cr_amount=form_data.get('amount', 0.00),     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()

    return jsonify({"msg": "Transaction created", "transaction_id": new_transaction.id}), 201
@main.route('/payment_transactions', methods=['POST'])
@jwt_required()
def payment_transactions():
    # Get the identity from the JWT token
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')
    create_uid = current_user.get('username')

    # Check if the request content type is valid
    if 'multipart/form-data' not in request.content_type and 'application/json' not in request.content_type:
        return jsonify({"msg": "Unsupported media type"}), 415

    # Initialize form data
    form_data = {}
    
    # Parse JSON if content type is application/json
    if 'application/json' in request.content_type:
        form_data = request.json
    else:
        form_data = request.form

    # Validate input data
    required_fields = ['date', 'v_no', 'ac_code', 'transaction_type']
    if not all(field in form_data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    # Check and create attachments directory if it doesn't exist
    attachments_dir = 'attachments/'+com_code+'/Purchase'+'/'+form_data['v_no']
    if not os.path.exists(attachments_dir):
        os.makedirs(attachments_dir)

    # Handle file upload if any
    attachment_file = request.files.get('attachment_file')
    attachment_path = None
    print(attachment_file)
    print('kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk file')
    if attachment_file:
        attachment_path = os.path.join(attachments_dir, attachment_file.filename)
        attachment_file.save(attachment_path)

    # Create a new transaction entry
    new_transaction = Transactions(
        date=form_data['date'],
        v_no=form_data['v_no'],
        com_code=com_code,
        ac_code=form_data['ac_code'],  # Sales
        transaction_type=form_data['transaction_type'],
        debit=form_data.get('debit', 0.00),
        credit=form_data.get('credit', 0.00),
        attachments=attachment_file,
        remarks=form_data.get('remarks'),
        next_followup=form_data.get('next_followup'),
        create_uid='bm'
    )

    db.session.add(new_transaction)
    db.session.commit()
    #Journal Voucher Sales
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=1,            # Serial number
    ac_code=form_data['ac_code'],        # Account code
    ac_id=789,          # Account ID
    descriptions = f'Purchase Bill NO {form_data["v_no"]}',  # Transaction description
    dr_amount=form_data.get('amount', 0.00),   # Debit amount
    cr_amount=0.00,     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()
    journal_voucher = fin_jv_transaction(
    ref_no=new_transaction.id,         # Reference number
    v_no=form_data['v_no'],   # Voucher number
    v_date=form_data['date'], # Transaction date (format: YYYY-MM-DD)
    sr_no=2,            # Serial number
    ac_code=1,        # Account code for 1 for cash
    ac_id=1,          # Account ID
    descriptions = f'Payment V NO {form_data["v_no"]}',  # Transaction description # Transaction description
    dr_amount=0.00,   # Debit amount
    cr_amount=form_data.get('amount', 0.00),     # Credit amount
    com_code=com_code  # Company code
    )
    db.session.add(journal_voucher)
    db.session.commit()

    return jsonify({"msg": "Transaction created", "transaction_id": new_transaction.id}), 201

@main.route('/ledger_report', methods=['POST','GET'])
@jwt_required()
def ledger_report():
    # Get filters from the request body
    data = request.get_json()
    from_date = data.get('from_date')
    to_date = data.get('to_date')
    ac_code =data.get('ac_code')  # New filter for account code
    ledger_name = "Cash"  # Replace with dynamic data if needed
    contact_number = "9845313151"  # Replace with dynamic data if needed
    opening_balance = 0  # Set the opening balance as needed
    opening_type='dr'
    
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')


    # Start building the query
    query = db.session.query(
        fin_jv_transaction.v_date,
        fin_jv_transaction.descriptions,
        fin_jv_transaction.dr_amount,
        fin_jv_transaction.cr_amount
    ).join(GL, GL.ac_code == fin_jv_transaction.ac_code)

    # Apply date filters if provided
    #if from_date and to_date:
    #    query = query.filter(fin_jv_transaction.v_date >= from_date, fin_jv_transaction.v_date <= to_date)

    # Apply account code filter if provided
    if ac_code:
        query = query.filter(
            fin_jv_transaction.ac_code == ac_code,
            fin_jv_transaction.com_code == com_code
        )


    # Execute the query and fetch results
    results = query.order_by(fin_jv_transaction.v_date).all()

    transactions = []
    
    if results:
        for result in results:
            transactions.append({
                'miti': result.v_date,  # Convert to string if necessary
                'Dscription': result.descriptions,
                'dr_amount': result.dr_amount,
                'cr_amount': result.cr_amount
            })

    # Structure the final response
    response = {
        "info": {
            "Ledger_name": ledger_name,
            "Contact": contact_number
        },
        "opening": opening_balance,
        "opening_type": opening_type,
        "Transactions": transactions
    }

    return jsonify(response), 200

@main.route('/signup', methods=['POST'])
def signup():
    data = request.get_json()
    print(data)

    # Get the identity from the JWT token
    
    
    # Validate input data
    required_fields = ['com_name', 'login_name','email','contact','password']
    if not all(field in data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    # Get the maximum gl_code from the database
    max_com_code = db.session.query(db.func.max(CompanySetup.com_code)).scalar()

    # Set the new gl_code
    max_com_code = max_com_code + 1 if max_com_code is not None else 1

    new_com = CompanySetup(
        com_code=max_com_code,  # Use calculated gl_code
        com_name=data['com_name'],
        shop_name=data['com_name'],
        owner_name=data['owner_name'],
        contact_person_mobile=data['contact'],
        email_id=data.get('email'),
    )
    db.session.add(new_com)
    db.session.commit()
    new_user = User(
        com_code=max_com_code,  # Use calculated gl_code
        login_name=data['login_name'],
        utype_id='',
        password=data['password'],
        user_full_name=data['owner_name'],
        abbreviation_id='bm',
        gsku_flag='I',
        user_cat_id='CUSTOMER_ADMIN',
    )
    db.session.add(new_user)
    db.session.commit()

    return jsonify({"msg": "Company created"}), 201


@main.route('/add_store', methods=['GET','POST'])
def add_store():
    
    return render_template('prk_template/add_store.html')

@main.route('/dealer_agent', methods=['GET','POST'])
def dealer_agent():
    
    return render_template('prk_template/dealer_agent.html')

@main.route('/product_catalog', methods=['GET','POST'])
def product_catalog():
    
    return render_template('prk_template/product_catalog.html')


@main.route('/get_municipalities', methods=['GET'])
def get_municipalities():
    query_for_municipality = (f"""
        SELECT ID, MUNCIPALITY FROM COUNTRY_SETUP ORDER BY MUNCIPALITY
        """)
    results = db.session.execute(query_for_municipality).fetchall()
    # Convert results to a list of dictionaries
    data = [{'ID': result[0], 'MUNCIPALITY': result[1]} for result in results]
    # print(f"data: {data}") 
    return jsonify(data)

@main.route('/get_service_area', methods=['GET'])
def get_service_area():
    query_for_service_area = (f"""
        SELECT ID, NAME FROM MASTER_SERVICE_AREA ORDER BY ID
        """)
    results = db.session.execute(query_for_service_area).fetchall()
    # Convert results to a list of dictionaries
    data = [{'ID': result[0], 'NAME': result[1]} for result in results]
    # print(f"data: {data}") 
    return jsonify(data)

@main.route('/get_shop_type', methods=['GET'])
def get_shop_type():
    query_for_shop_type = (f"""
        SELECT ID, NAME FROM MASTER_SHOP_TYPE ORDER BY ID
        """)
    results = db.session.execute(query_for_shop_type).fetchall()
    # Convert results to a list of dictionaries
    data = [{'ID': result[0], 'NAME': result[1]} for result in results]
    # print(f"data: {data}") 
    return jsonify(data)

@main.route('/get_business_category', methods=['GET'])
def get_business_category():
    query_for_business_category = (f"""
        SELECT ID, NAME FROM MASTER_BUSINESS_CATEGORY ORDER BY ID
        """)
    results = db.session.execute(query_for_business_category).fetchall()
    # Convert results to a list of dictionaries
    data = [{'ID': result[0], 'NAME': result[1]} for result in results]
    # print(f"data: {data}") 
    return jsonify(data)



@main.route('/add_store_data_insertion', methods=['POST'])
@jwt_required()
def add_store_data_insertion():
    current_user = get_jwt_identity()
    print(f"current_user:{current_user}")
    com_code = current_user.get('com_code')
    user_id = current_user.get('user_id')
    qry = 'select nvl(max(id)+1, 1) as id from store_info'
    res_record = db.session.execute(qry)

    for res in res_record:
        max_id = res.id


    # upload_folder = './attatchments/store_info'
    
    
    # if not os.path.exists(upload_folder):
    #     os.makedirs(upload_folder)

    # Create attachments directory
    attachments_dir = os.path.join('attachments','store_info', com_code, str(max_id))
    os.makedirs(attachments_dir, exist_ok=True)

    # Handle file upload
    # attachment_file = request.files.get('attachment_file')
    # attachment_path = None
    # if attachment_file:
    #     attachment_path = os.path.join(attachments_dir, attachment_file.filename)
    #     attachment_file.save(attachment_path)

    # Handle business_logo upload
    business_logo_file = request.files.get('business_logo')
    business_logo = ''
    if business_logo_file:
        business_logo_path = os.path.join(attachments_dir, 'logo.png')
        business_logo_file.save(business_logo_path)
        business_logo = 'logo.png'

    # Handle shop_cover_photo upload
    shop_cover_photo_file = request.files.get('shop_cover_photo')
    shop_cover_photo = ''
    if shop_cover_photo_file:
        shop_cover_photo_path = os.path.join(attachments_dir, 'cover.png')
        shop_cover_photo_file.save(shop_cover_photo_path)
        shop_cover_photo = 'cover.png'

    # Handle thumbnail upload
    thumbnail_file = request.files.get('thumbnail')
    thumbnail = ''
    if thumbnail_file:
        thumbnail_path = os.path.join(attachments_dir, 'thumbnail.png')
        thumbnail_file.save(thumbnail_path)
        thumbnail = 'thumbnail.png'
    

    # Get form data
    data = request.form.to_dict()

    #Social Media Link
    social_media_link = []

    Facebook = data.get('facebook')
    YouTube = data.get('youtube')
    TikTok = data.get('tiktok')
    Instagram = data.get('instagram')

    # Append non-empty links to the list
    if Facebook:
        social_media_link.append(Facebook)
    if YouTube:
        social_media_link.append(YouTube)
    if TikTok:
        social_media_link.append(TikTok)
    if Instagram:
        social_media_link.append(Instagram)

    # Join the links into a single string, separated by commas
    social_media_links = ', '.join(social_media_link)

    established_date = data.get('established_date')
    established_date = datetime.strptime(established_date, "%Y-%m-%d").strftime("%d-%b-%Y") if established_date else '' 

    service_area= data.get('service_area') if data.get('service_area') != 'Select Service Area' else ''
    business_category= data.get('business_category') if data.get('business_category') != 'Select Business Category' else ''
    shop_type= data.get('shop_type') if data.get('shop_type') != 'Select Shop Type' else ''
    municipality= data.get('municipality') if data.get('municipality') != 'Select Municipality' else ''

    
    # Save the store info
    store_info = STORE_INFO(
        com_code= int(com_code), 
        shop_name=data.get('shop_name'),
        display_name=data.get('display_name'),
        pan_number=data.get('pan_number'),
        owner_name=data.get('owner_name'),
        shop_description=data.get('shop_description'),
        contact_person_name=data.get('contact_person_name'),
        contact_person_mobile=data.get('contact_person_mobile'),
        contact_email=data.get('contact_email'),
        phone_number=data.get('phone_number'),
        mobile_number=data.get('mobile_number'),
        whatsapp_number=data.get('whatsapp_number'),
        established_date=established_date,
        dealing_brands=data.get('brands'),
        service_area = service_area,
        business_category = business_category,
        shop_type = shop_type,
        city=data.get('city'),
        postal_code = '',
        country = 'Nepal',
        municipality = municipality,
        landmark = data.get('landmark'),
        latitude = data.get('latitude'),
        longitude = data.get('longitude'),
        website_url = data.get('website_url'),
        social_media_links = social_media_links,
        seo_keywords = '',
        opening_hours = '',
        post_content = '',
        show_flag = 'N',
        lock_flag = 'N',
        verified_flag = 'N',
        verified_suppliers_flag = 'N',
        business_logo = business_logo,
        shop_cover_photo = shop_cover_photo,
        thumbnail = thumbnail,
        youtube_ad = data.get('youtube_ad'),
        create_by = user_id,
        dealer_id = ''

    )

    # Add the store info to the session and commit
    db.session.add(store_info)
    db.session.commit()


    # Return a success response
    response_data = {
        'message': 'Store data received and saved successfully',
        'store_info': {
            'id': store_info.id,
            'shop_name': store_info.shop_name,
            'display_name': store_info.display_name,
            # Add other fields as necessary
        }
        # 'uploaded_files': saved_files
    }
    
    return jsonify(response_data)

@main.route('/dealer_data_insertion', methods=['POST'])
@jwt_required()
def dealer_data_insertion():
    current_user = get_jwt_identity()
    print(f"current_user:{current_user}")
    com_code = current_user.get('com_code')
    user_id = current_user.get('user_id')
    qry = 'select nvl(max(id)+1, 1) as id from dealer_info'
    res_record = db.session.execute(qry)

    for res in res_record:
        max_id = res.id

    agent_code = (f"A{max_id}")


    # upload_folder = './attatchments/store_info'
    
    
    # if not os.path.exists(upload_folder):
    #     os.makedirs(upload_folder)

    # Create attachments directory
    attachments_dir = os.path.join('attachments','dealer_info', com_code, str(max_id))
    os.makedirs(attachments_dir, exist_ok=True)

    
    # Handle business_logo upload
    id_image1_file = request.files.get('id_image1')
    id_image1 = ''
    if id_image1_file:
        id_image1_path = os.path.join(attachments_dir, 'id_image1.png')
        id_image1_file.save(id_image1_path)
        id_image1 = 'id_image1.png'

    id_image2_file = request.files.get('id_image2')
    id_image2 = ''
    if id_image2_file:
        id_image2_path = os.path.join(attachments_dir, 'id_image2.png')
        id_image2_file.save(id_image2_path)
        id_image2 = 'id_image2.png'

    profile_image_file = request.files.get('profile_image')
    profile_image = ''
    if profile_image_file:
        profile_image_path = os.path.join(attachments_dir, 'profile_image.png')
        profile_image_file.save(profile_image_path)
        profile_image = 'profile_image.png'

    
    

    # Get form data
    data = request.form.to_dict()

    
    id_type = data.get('id_type') if data.get('id_type') != 'Select ID Type' else ''

    
    # Save the store info
    dealer_info = DEALER_INFO(
        com_code= int(com_code), 
        dealer_name=data.get('dealer_name'),
        address=data.get('address'),
        owner_name=data.get('owner_name'),
        allotted_address=data.get('alloted_address'),
        email=data.get('email'),
        contact1=data.get('contact1'),
        contact2=data.get('contact2'),
        remarks=data.get('remarks'),
        active_flag = 'Y',
        lock_flag = 'N',
        created_by= user_id,
        id_type= id_type,
        id_no=data.get('id_number'),
        id_image1 = id_image1,
        id_image2 = id_image2,
        profile_image = profile_image,
        agent_code =  agent_code,
        dealer_agent = 'BM'

    )

    # Add the store info to the session and commit
    db.session.add(dealer_info)
    db.session.commit()


    # Return a success response
    response_data = {
        'message': 'Store data received and saved successfully',
        'store_info': {
            'id': dealer_info.id,
        }
        # 'uploaded_files': saved_files
    }
    
    return jsonify(response_data)

@main.route('/create_catelog_date_insertion', methods=['POST'])
@jwt_required()
def create_catelog_date_insertion():
    current_user = get_jwt_identity()
    print(f"current_user:{current_user}")
    com_code = current_user.get('com_code')
    user_id = current_user.get('user_id')
    qry = 'select nvl(max(id)+1, 1) as id from products'
    res_record = db.session.execute(qry)

    for res in res_record:
        max_id = res.id

    agent_code = (f"A{max_id}")

    # Get form data
    data = request.form.to_dict()

    
    # id_type = data.get('id_type') if data.get('id_type') != 'Select ID Type' else ''
    product_name = data.get('product_name')
    sku = data.get('sku')
    brand_name = data.get('brand_name')

    price = data.get('price')
    if isinstance(price, str):
        price = float(price)

    # Parse colors and sizes as lists
    colors = json.loads(data.get('colors', '[]'))  # Default to an empty list if not provided
    sizes = json.loads(data.get('sizes', '[]'))    # Default to an empty list if not provided


    print("UKG")
    print(colors)
    print(sizes)

    for color in colors:
        for size in sizes:
            # Save the store info
            PRODUCT = PRODUCTS(
                com_code= int(com_code), 
                product_name=data.get('product_name'),
                brand = data.get('brand_name'),
                price=price,
                created_by= user_id,
                color = color,
                size= size
            )

            # Add the store info to the session and commit
            db.session.add(PRODUCT)
    db.session.commit()


    # Return a success response
    response_data = {
        'message': 'Store data received and saved successfully',
        'store_info': {
            'id': '',
        }
        # 'uploaded_files': saved_files
    }
    
    return jsonify("response_data")

