from flask import Blueprint, render_template, jsonify, request,redirect
from flask_jwt_extended import create_access_token, jwt_required,get_jwt_identity
from . import db
from .models import *  # Import your models
from datetime import datetime, timedelta
import os
prk = Blueprint('prk', __name__)



@prk.route('/motor_master', methods=['POST', 'GET'])
@jwt_required()
def motor_master():
    # Query only the 'code' and 'name' columns from the Master table
    masters = Prk_motor_type.query.with_entities(Prk_motor_type.id, Prk_motor_type.type).all()

    if masters:
        # Create a list of dictionaries for each master record
        res_data = [{'code': master.id, 'name': master.type} for master in masters]

        return jsonify(res_data), 200

    return jsonify({"msg": "No records found"}), 404

@prk.route('/ac_master_x', methods=['POST', 'GET'])
@jwt_required()
def ac_master_X():
    # Get the identity from the JWT
    current_user = get_jwt_identity()
    
    # Assuming 'com_code' is part of the user data in the JWT
    com_code_value = current_user.get('com_code')  # Adjust key based on your JWT payload

    if com_code_value is None:
        return jsonify({"msg": "com_code not found in token"}), 400
    print(com_code_value)

    # Query only the 'code', 'name', and 'abr' columns from the GL table
    #masters = GL.query(GL.ac_code, GL.ac_name, GL.ac_abr).filter(GL.com_code == com_code_value).all()
    #masters = GL.query.with_entities(GL.ac_code, GL.ac_name, GL.ac_abr).filter(GL.com_code == com_code_value).all()
    masters = GL.query.with_entities(GL.ac_code, GL.ac_name, GL.ac_abr) \
    .filter((GL.com_code == com_code_value) | (GL.com_code == 0)) \
    .all()



    if masters:
        # Create a list of dictionaries for each master record
        res_data = [{'ac_code': master.ac_code, 'ac_name': master.ac_name, 'abr': master.ac_abr} for master in masters]

        return jsonify(res_data), 200

    return jsonify({"msg": "No records found"}), 404

@prk.route('/park_in', methods=['POST'])
@jwt_required()
def park_in():
    # Get the identity from the JWT token
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')
    user_id = current_user.get('user_id')

    # Validate request content type
    if 'multipart/form-data' not in request.content_type and 'application/json' not in request.content_type:
        return jsonify({"msg": "Unsupported media type"}), 415

    # Parse form data
    form_data = request.json if 'application/json' in request.content_type else request.form
    print(form_data)
    # Validate input data
    required_fields = ['motor_type', 'motorist_name', 'vehicle_plate_no']
    if not all(field in form_data for field in required_fields):
        return jsonify({"msg": "Missing required fields"}), 400

    
    # Create attachments directory
    attachments_dir = os.path.join('attachments', com_code, 'Parking')
    os.makedirs(attachments_dir, exist_ok=True)

    # Handle file upload
    attachment_file = request.files.get('attachment_file')
    attachment_path = None
    if attachment_file:
        attachment_path = os.path.join(attachments_dir, attachment_file.filename)
        attachment_file.save(attachment_path)
    print(form_data['motor_type'])
    # Create a new transaction entry
    new_transaction = prk_ParkingOperation(
        type=form_data['motor_type'],
        motorist_name=form_data['motorist_name'],
        vehicle_plate_no=form_data['vehicle_plate_no'],
        attachments=attachment_path,  # Store the path instead of the file object
        com_code=com_code,
        park_in_uid=user_id
    )
    #print(new_transaction)
    try:
        db.session.add(new_transaction)
        db.session.commit()
    except Exception as e:
        db.session.rollback()
        return jsonify({"msg": "Database error", "error": str(e)}), 500

    return jsonify({"msg": "Park In Admitted"}), 201


@prk.route('/parking_info', methods=['POST', 'GET'])
@jwt_required()
def parking_info():
    # Get filters from the request body
    data = request.get_json()
    
    if not data or 'parking_id' not in data:
        return jsonify({'msg': 'Missing parking_id in request'}), 400
    
    parking_id = data['parking_id']
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')

    # Start building the query
    query = db.session.query(
        prk_ParkingOperation.id,
        prk_ParkingOperation.type,
        prk_ParkingOperation.motorist_name,
        prk_ParkingOperation.park_in_time,
        prk_ParkingOperation.vehicle_plate_no  # Ensure this field exists
    ).filter(
        prk_ParkingOperation.id == parking_id
    )

    # Execute the query and fetch results
    result = query.first()  # Use first() to get a single record

    if result:
        # Prepare the response
        response = {
            "Park_Info": {
                "id": result.id,
                "type": result.type,
                "motorist": result.motorist_name,
                "Vehicle_plate_no": result.vehicle_plate_no,
                "park_in_time": result.park_in_time  # Format as needed
            }
        }
        return jsonify(response), 200
    else:
        return jsonify({'msg': 'Parking information not found'}), 404

@prk.route('/park_outx', methods=['POST', 'GET'])
@jwt_required()
def park_ouxt():
    # Get filters from the request body
    data = request.get_json()
    print('Received data:', data)
    
    if not data or 'parking_id' not in data:
        return jsonify({'msg': 'Missing parking_id in request'}), 400
    
    parking_id = data['parking_id']
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')

    # Find the parking operation record
    parking_record = db.session.query(prk_ParkingOperation).filter(
        prk_ParkingOperation.id == parking_id
    ).first()

    if parking_record:
        # Update the park_out_time
        parking_record.park_out_time = datetime.now()  # Set the current time as park out time
         # Calculate total park time in minutes
        total_minutes = (datetime.now() - parking_record.park_in_time).total_seconds() / 60
        
        # Calculate total park time in hours as a decimal
        parking_record.total_park_time = total_minutes / 60
        
        try:
            db.session.commit()  # Commit the changes to the database
            qry=f'''
            UPDATE prk_parkingoperation SET amount=(SELECT hour_rate from prk_parking_rate_setup WHERE motor_type='{parking_record.type}')*total_park_time where id={parking_record.id} AND PAID_TYPE !='FREE'
            '''
            res=db.session.execute(qry)
            db.session.commit()
            response = {
                "msg": "Park-out time updated successfully",
                "Park_Info": {
                    "id": parking_record.id,
                    "type": parking_record.type,
                    "motorist": parking_record.motorist_name,
                    "Vehicle_plate_no": parking_record.vehicle_plate_no,
                    "park_in_time": parking_record.park_in_time,
                    "park_out_time": parking_record.park_out_time  # Include park out time in the response
                }
            }
            return jsonify(response), 200
        except Exception as e:
            db.session.rollback()  # Rollback in case of error
            return jsonify({'msg': 'Error updating park out time', 'error': str(e)}), 500
    else:
        return jsonify({'msg': 'Parking information not found'}), 404

from decimal import Decimal

@prk.route('/park_out', methods=['POST', 'GET'])
@jwt_required()
def park_out():
    # Get filters from the request body
    data = request.get_json()
    print('Received data:', data)

    if not data or 'parking_id' not in data:
        return jsonify({'msg': 'Missing parking_id in request'}), 400

    parking_id = data['parking_id']
    current_user = get_jwt_identity()
    com_code = current_user.get('com_code')
    uid=current_user.get('user_id')

    # Find the parking operation record
    parking_record = db.session.query(prk_ParkingOperation).filter(
        prk_ParkingOperation.id == parking_id
    ).first()

    if parking_record:
        # Update the park_out_time
        parking_record.park_out_time = datetime.now()  # Set the current time as park out time
        parking_record.park_out_uid = uid
        parking_record.com_code = com_code

        # Calculate total park time in minutes
        total_minutes = (parking_record.park_out_time - parking_record.park_in_time).total_seconds() / 60
        
        # Calculate total park time in hours as a decimal
        parking_record.total_park_time = Decimal(total_minutes / 60)  # Convert to Decimal
        
        # Fetch hour rate based on motor type
        hour_rate = db.session.query(ParkingRateSetup.hour_rate).filter(
            ParkingRateSetup.motor_type == parking_record.type
        ).scalar()  # Get a single value
        
        # Ensure hour_rate is a Decimal
        if hour_rate is not None:
            parking_record.amount = Decimal(hour_rate) * parking_record.total_park_time  # Ensure both are Decimal
        else:
            return jsonify({'msg': 'Hour rate not found for the given motor type'}), 404

        try:
            db.session.commit()  # Commit the changes to the database
            
            response = {
                "msg": "Park-out time updated successfully",
                "Park_Info": {
                    "id": parking_record.id,
                    "type": parking_record.type,
                    "motorist": parking_record.motorist_name,
                    "Vehicle_plate_no": parking_record.vehicle_plate_no,
                    "park_in_time": parking_record.park_in_time,
                    "park_out_time": parking_record.park_out_time,  # Include park out time in the response
                    "total_park_time": float(parking_record.total_park_time),  # Convert back to float for response
                    "amount": float(parking_record.amount)  # Convert back to float for response
                }
            }
            return jsonify(response), 200
        except Exception as e:
            db.session.rollback()  # Rollback in case of error
            return jsonify({'msg': 'Error updating park out time', 'error': str(e)}), 500
    else:
        return jsonify({'msg': 'Parking information not found'}), 404


@prk.route('/prk_login')
def prk_logoin():
    return render_template('prk_template/auth-login.html')
@prk.route('/prk_home')
def prk_home():
    return render_template('prk_template/prk_operation.html')

@prk.route('/prk_operation')
def prk_operation():
    return render_template('prk_template/prk_operation.html')
@prk.route('/prk_free_operation')
def prk_free_operation():
    return render_template('prk_template/prk_free_operation.html')

@prk.route('/prk_operation_api', methods=['POST', 'GET'])
def prk_operation_api():
    # Get filters from the request body
    #data = request.get_json()
    #print('Received data:', data)

    try:
        qry = """
        SELECT id, type, motorist_name, vehicle_plate_no, date, park_in_time, nvl(park_out_time,'0') as park_out_time, NVL(total_park_time, 0) AS total_park_time, 
        nvl(paid_type,'0') as paid_type, amount,'BB' AS PB_LAYOUT
        FROM prk_parkingoperation
        WHERE 1=1
        """
        
        # Execute the query and fetch results
        result = db.session.execute(qry)
        records = result.fetchall()  # Fetch all records from the result
        
        if not records:
            return jsonify({'msg': 'Parking information not found'}), 404
        
        # Process records into a list of dictionaries using column names as keys
        park_info = []
        column_keys = result.keys()  # Get column names from the result

        for parking_record in records:
            park_info.append({
                key: (getattr(parking_record, key).isoformat() if isinstance(getattr(parking_record, key), datetime) else getattr(parking_record, key))
                for key in column_keys
            })
        
        response = {
            "Park_Info": park_info
        }
        return jsonify(response), 200

    except Exception as e:
        db.session.rollback()  # Rollback in case of error
        return jsonify({
            'msg': 'Error retrieving parking information',
            'error': str(e)
        }), 500
@prk.route('/prk_logout')
def prk_logout():
    
    return redirect('/prk_login')
  
@prk.route('/free_park', methods=['POST', 'GET'])
@jwt_required()
def free_park():
    # Get filters from the request body
    data = request.get_json()
    print('Received data:', data)

    # Validate request data
    if not data or 'park_id' not in data:
        return jsonify({'msg': 'Missing parking_id in request'}), 400

    parking_id = data['park_id']
    current_user = get_jwt_identity()

    # Find the parking operation record
    parking_record = db.session.query(prk_ParkingOperation).filter(
        prk_ParkingOperation.id == parking_id
    ).first()

    if parking_record:
        # Update the paid_type to 'Free'
        parking_record.paid_type = 'Free'

        try:
            db.session.commit()  # Commit the changes to the database
            
            # Prepare the response data
            response = {
                "msg": "Park-out time updated successfully",
                "Park_Info": {
                    "id": parking_record.id,
                    "type": parking_record.type,
                    "motorist": parking_record.motorist_name,
                    "vehicle_plate_no": parking_record.vehicle_plate_no,
                    "park_in_time": parking_record.park_in_time,
                    "park_out_time": parking_record.park_out_time,  # Assuming you have set this elsewhere
                    "total_park_time": float(parking_record.total_park_time),
                    "amount": float(parking_record.amount)
                }
            }
            return jsonify(response), 200

        except Exception as e:
            db.session.rollback()  # Rollback in case of error
            print('Error during commit:', str(e))  # Log the error for debugging
            return jsonify({'msg': 'Error updating park-out time', 'error': str(e)}), 500
    else:
        return jsonify({'msg': 'Parking information not found'}), 404
