from sqlalchemy import Column, Integer, String, Text, Boolean, Date, DECIMAL, TIMESTAMP, ForeignKey, Float
from sqlalchemy.sql import func
from .database import db  # Import the db instance from the new file
from sqlalchemy import Sequence


class CompanySetup(db.Model):
    __tablename__ = 'company_setup'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    
    # Fields from the provided data
    com_code = Column(Integer, nullable=False)  # Assuming VARString2 (5 Byte) translates to String(5)
    com_name = Column(String(100), nullable=False)
    grand_com_code = Column(String(30))
    address = Column(String(100))
    pan_no = Column(Integer)  # Assuming NUMBER (9) translates to Integer
    tel_no = Column(String(50))
    email_id = Column(String(50))
    fax_no = Column(String(50))
    website = Column(String(50))
    logo_file_name = Column(String(500))
    make_uid = Column(String(30))
    make_date = Column(Date)
    registration_no = Column(String(100))
    exim_code = Column(String(30))
    bottom_logo_file_name = Column(String(300))
    consolidate_flag = Column(String(1))  # String (1 Byte)
    abbreviation_id = Column(String(6))
    smtp_host = Column(String(50))
    remarks = Column(String(100))
    sync_id = Column(String(18))
    mdy_uid = Column(String(30))
    mdy_date = Column(Date)
    recycled_uid = Column(String(30))
    recycled_date = Column(Date)
    recycled_flag = Column(String(1))  # String (1 Byte)
    amc_renewal_date = Column(Date)
    excise_no = Column(String(20))
    com_type = Column(String(25))
    com_nature = Column(String(100))
    organization = Column(String(50))
    stamp_path = Column(String(100))
    gst_no = Column(String(20))
    iec_no = Column(String(20))
    state_name = Column(String(50))
    catalog_id = Column(Integer)
    dealer_id = Column(Integer)
    shop_name = Column(String(255), nullable=True)
    display_name = Column(String(255))
    login_name = Column(String(100), unique=True)
    password = Column(String(255))
    business_code = Column(String(100))
    pan_number = Column(String(20))
    shop_description = Column(Text)
    owner_name = Column(String(100))
    contact_person_name = Column(String(100))
    contact_person_mobile = Column(String(15))
    contact_email = Column(String(100), unique=True)
    phone_number = Column(String(15))
    mobile_number = Column(String(15))
    whatsapp_number = Column(String(15))
    city = Column(String(100))
    postal_code = Column(String(20))
    country = Column(String(100))
    municipality = Column(String(100))
    landmark = Column(String(255))
    latitude = Column(DECIMAL(9, 6))
    longitude = Column(DECIMAL(9, 6))
    website_url = Column(String(255))
    social_media_links = Column(Text)
    seo_keywords = Column(String(255))
    opening_hours = Column(String(100))
    featured_products = Column(Text)
    shop_type = Column(String(50))
    service_area = Column(String(255))
    business_category = Column(String(50))
    post_content = Column(Text)
    show_flag = Column(Boolean, default=True)
    lock_flag = Column(Boolean, default=False)
    verified_flag = Column(Boolean, default=False)
    verified_suppliers_flag = Column(Boolean, default=False)
    established_date = Column(Date)
    expiry_date = Column(Date)
    grace_day = Column(Integer)
    next_renew_date = Column(Date)
    payment_amount = Column(DECIMAL(10, 2))
    payment_reference_no = Column(String(100))
    payment_date = Column(Date)
    verify_date = Column(Date)
    no_of_store_visits = Column(Integer, default=0)
    no_of_followers = Column(Integer, default=0)
    no_of_experience_years = Column(Integer, default=0)
    dealing_brands = Column(Text)
    business_logo = Column(String(255))
    shop_cover_photo = Column(String(255))
    thumbnail = Column(String(255))
    youtube_ad = Column(String(255))
    
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class STORE_INFO(db.Model):
    __tablename__ = 'STORE_INFO'
    
    id = Column(Integer, Sequence('store_info_seq'), primary_key=True)
    com_code = Column(Integer)
    shop_name = Column(String(255))
    display_name = Column(String(255), nullable=True)
    pan_number = Column(String(20), nullable=True)
    shop_description = Column(String(255), nullable=True)
    owner_name = Column(String(100), nullable=True)  
    contact_person_name = Column(String(100), nullable=True)
    contact_person_mobile = Column(String(15), nullable=True) 
    contact_email = Column(String(100), nullable=True) 
    phone_number = Column(String(15), nullable=True)
    mobile_number = Column(String(15), nullable=True)  
    whatsapp_number = Column(String(15), nullable=True)
    city = Column(String(100), nullable=True)
    postal_code = Column(String(20), nullable=True)
    country = Column(String(100), nullable=True)
    municipality = Column(String(100), nullable=True)  
    landmark = Column(String(255), nullable=True)
    latitude = Column(String(255), nullable=True) 
    longitude = Column(String(255), nullable=True) 
    website_url = Column(String(255), nullable=True)
    social_media_links = Column(String(255), nullable=True)  
    seo_keywords = Column(String(255), nullable=True)  
    opening_hours = Column(String(100), nullable=True)  
    shop_type = Column(String(50), nullable=True)  
    service_area = Column(String(255), nullable=True)
    business_category = Column(String(50), nullable=True)  
    post_content = Column(String(4000), nullable=True)
    show_flag = Column(String(1), nullable=True)
    lock_flag = Column(String(1), nullable=True)
    verified_flag = Column(String(1), nullable=True)
    verified_suppliers_flag = Column(String(1), nullable=True)
    established_date = Column(Date, nullable=True)
    dealing_brands = Column(String(255), nullable=True)
    business_logo = Column(String(255), nullable=True)
    shop_cover_photo = Column(String(255), nullable=True)  
    thumbnail = Column(String(255), nullable=True)
    youtube_ad = Column(String(255), nullable=True)
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())
    create_by = Column(Integer, nullable=True)
    update_by = Column(Integer, nullable=True)
    dealer_id = Column(Integer, nullable=True)


class DEALER_INFO(db.Model):
    __tablename__ = 'DEALER_INFO'
    
    id = Column(Integer, Sequence('dealer_seq'), primary_key=True)
    com_code = Column(Integer)
    dealer_id = Column(Integer, Sequence('dealer_seq'))  # Unique dealer identifier
    dealer_name = Column(String(255), nullable=True)
    address = Column(String(255), nullable=True)
    owner_name = Column(String(255), nullable=True)
    allotted_address = Column(String(255), nullable=True)
    email = Column(String(255), nullable=True)
    contact1 = Column(String(15), nullable=True)
    contact2 = Column(String(15), nullable=True)
    remarks = Column(String(255), nullable=True)
    active_flag = Column(String(1), default='Y')  # Using Boolean for active flag
    lock_flag = Column(String(1), default='N')  # Using Boolean for lock flag
    created_by = Column(String(100), nullable=True)
    created_date = Column(TIMESTAMP, server_default=func.now())
    id_type = Column(String(50), nullable=True)
    id_no = Column(String(50), nullable=True)
    id_image1 = Column(String(255), nullable=True)  # Path or URL to the ID image
    id_image2 = Column(String(255), nullable=True)  # Path or URL to the ID image
    profile_image = Column(String(255), nullable=True)  # Path or URL to the profile image
    agent_code = Column(String(50), nullable=True)
    dealer_agent = Column(String(100), nullable=True)

    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class PRODUCTS(db.Model):
    __tablename__ = 'PRODUCTS'
    
    id = Column(Integer, Sequence('product_seq'), primary_key=True)
    product_code = Column(String(255), nullable=True)
    product_name = Column(String(255), nullable=True)
    product_description = Column(String(255), nullable=True)
    brand = Column(String(255), nullable=True)
    category_id = Column(Integer, nullable=True)
    size = Column(String(50), nullable=True)
    color = Column(String(50), nullable=True)
    origin = Column(String(100), nullable=True)
    price = Column(DECIMAL(10, 2), nullable=True)
    com_code = Column(String(100), nullable=True)
    hot_product = Column(String(1), default='N' )
    featured_product = Column(String(1), default='N')
    product_show_flag = Column(String(1), default='Y')
    product_lock_flag = Column(String(1), default='N')
    seo_keywords = Column(String(255), nullable=True)
    seo_description = Column(String(255), nullable=True)
    no_of_views = Column(Integer, default=0)
    video_url_1 = Column(String(255), nullable=True)
    video_url_2 = Column(String(255), nullable=True)
    video_url_3 = Column(String(255), nullable=True)
    recycled_flag = Column(String(1), default='N')
    created_by = Column(String(100), nullable=True)
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())


class PRODUCTDETAILS(db.Model):
    __tablename__ = 'PRODUCTDETAILS'
    
    id = Column(Integer, Sequence('productdetails_seq'), primary_key=True)
    product_code = Column(String(255), nullable=True)
    product_name = Column(String(255), nullable=True)
    product_description = Column(String(255), nullable=True)
    brand = Column(String(255), nullable=True)
    category_id = Column(Integer, nullable=False)
    sku = Column(String(255), nullable=True)
    size = Column(String(50), nullable=True)
    color = Column(String(50), nullable=True)
    origin = Column(String(100), nullable=True)
    price = Column(DECIMAL(10, 2), nullable=True)
    com_code = Column(String(100), nullable=True)
    sn_no = Column(String(100), nullable=False)
    hot_product = Column(Boolean, default=False)
    featured_product = Column(Boolean, default=False)
    product_show_flag = Column(Boolean, default=True)
    product_lock_flag = Column(Boolean, default=False)
    seo_keywords = Column(String(255), nullable=True)
    seo_description = Column(String(255), nullable=True)
    no_of_views = Column(Integer, default=0)
    video_url_1 = Column(String(255), nullable=True)
    video_url_2 = Column(String(255), nullable=True)
    video_url_3 = Column(String(255), nullable=True)
    recycled_flag = Column(String(1), default='N')
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class ITEM_INFO(db.Model):
    _tablename_ = 'ITEM_INFO'
    
    item_code = Column(Integer, primary_key=True)  # IT_CODE
    item_id = Column(String(15), nullable=False)  # IT_ID
    item_name = Column(String(200), nullable=False)  # IT_NAME
    item_description = Column(String(1000), nullable=True)  # IT_DESCRIPTION
    base_unit = Column(String(5), nullable=True)  # KEY_UNIT
    transaction_unit = Column(String(5), nullable=True)  # TRANS_UNIT
    category_id = Column(String(2), nullable=True)  # CAT_ID
    dimensions = Column(String(10), nullable=True)  # DIMENSION
    fractional_value = Column(Float, nullable=True)  # FRACTION_VALUE
    parent_item_code = Column(String(30), nullable=False)  # MOTHER_IT_CODE
    grand_parent_item_code = Column(String(30), nullable=False)  # GRAND_IT_CODE
    image_filename = Column(String(1000), nullable=True)  # IMAGE_FILE_NAME
    shelf_life_in_days = Column(Integer, nullable=True)  # SHELF_LIFE_DAYS
    max_inventory_level = Column(Float, nullable=True)  # MAXIMUM_LEVEL
    min_inventory_level = Column(Float, nullable=True)  # MINIMUM_LEVEL
    preferred_inventory_level = Column(Float, nullable=True)  # PREFERD_LEVEL
    reorder_inventory_level = Column(Float, nullable=True)  # REORDER_LEVEL
    danger_inventory_level = Column(Float, nullable=True)  # DANGER_LEVEL
    economy_order_quantity = Column(Float, nullable=True)  # ECNOMY_ORDER_QTY
    preferred_vendor_code = Column(String(30), nullable=True)  # PREFERD_VENDOR_CODE
    lead_time_in_days = Column(Integer, nullable=True)  # LEAD_TIME
    average_rate = Column(Float, nullable=True)  # AVG_RATE
    current_landed_cost = Column(Float, nullable=True)  # CURRENT_LANDED_COST
    current_sales_price = Column(Float, nullable=True)  # CURRENT_SALES_PRICE
    default_wip_inventory = Column(Float, nullable=True)  # DEFAULT_WIP_STOCK
    valuation_method_flag = Column(String(1), nullable=True)  # VALUATION_METHOD_FLAG
    group_flag = Column(String(1), nullable=True)  # GROUP_ID
    hs_code = Column(String(20), nullable=True)  # HS_CODE
    serial_code = Column(String(30), nullable=True)  # SL_CODE
    service_product_flag = Column(String(1), nullable=True)  # SERVICE_FLAG
    vehicle_transport_flag = Column(String(1), nullable=True)  # VEHICLE_TRANS_FLAG
    sr_transport_flag = Column(String(1), nullable=True)  # SR_TRANS_FLAG
    bt_transport_flag = Column(String(1), nullable=True)  # BT_TRANS_FLAG
    bt_sr_transport_flag = Column(String(1), nullable=True)  # BT_SR_TRANS_FLAG
    warranty_flag = Column(String(1), nullable=True)  # W_FLAG
    manufacturing_capacity = Column(Integer, nullable=True)  # MFG_CAPACITY
    manufacturing_expiry_date = Column(Integer, nullable=True)  # MFG_EXPIRY_DATE
    ownership_flag = Column(String(3), nullable=True)  # OWNERSHIP
    non_moveable_flag = Column(String(1), default='N', nullable=True)  # NON_MOVEABLE_FLAG
    expiry_flag = Column(String(1), default='N', nullable=True)  # EXPIRY_FLAG
    company_code = Column(String(30), nullable=False)  # COM_CODE
    brand_code = Column(String(6), nullable=True)  # BRA_CODE
    gsku_flag = Column(String(1), nullable=True)  # GSKU_FLAG
    manufacturer_uid = Column(String(30), nullable=True)  # MAKE_UID
    manufacture_date = Column(Date, nullable=True)  # MAKE_DATE
    modified_by_uid = Column(String(30), nullable=True)  # MDY_UID
    modified_date = Column(Date, nullable=True)  # MDY_DATE
    valuation_flag = Column(String(1), nullable=True)  # VALUATION_FLAG
    remarks = Column(String(200), nullable=True)  # REMARKS
    secondary_remarks = Column(String(200), nullable=True)  # REMARKS2ND
    min_sales_value = Column(Float, nullable=True)  # MIN_SALES_VALUE
    max_sales_value = Column(Float, nullable=True)  # MAX_SALES_VALUE
    sr_prefix_text = Column(String(3), nullable=True)  # SR_PFIX_TXT
    sr_prefix_length = Column(Integer, nullable=True)  # SR_PFIX_LENGTH
    transaction_lock_flag = Column(String(1), default='N', nullable=True)  # TRANS_LOCK_FLAG
    opening_account_code = Column(String(30), nullable=True)  # OPENING_AC_CODE
    reem_weight_kg = Column(Float, nullable=True)  # REEM_WEIGHT_KG
    item_brand_name = Column(String(30), nullable=True)  # IT_BRAND_NAME
    company_name = Column(String(30), nullable=True)  # COMPANY_NAME
    technical_specifications = Column(String(200), nullable=True)  # IT_SPEC
    serial_number = Column(String(30), nullable=True)  # IT_SR_NO
    part_number = Column(String(30), nullable=True)  # IT_PART_NO
    model_number = Column(String(30), nullable=True)  # IT_MODEL_NO
    equipment_id = Column(String(30), nullable=True)  # IT_EQUIPMENT_ID
    item_size = Column(String(30), nullable=True)  # IT_SIZE
    item_type = Column(String(20), nullable=True)  # IT_TYPE
    item_gsm = Column(String(30), nullable=True)  # IT_GSM
    item_length = Column(String(30), nullable=True)  # IT_LENGTH
    item_width = Column(String(30), nullable=True)  # IT_WIDTH
    item_weight = Column(String(30), nullable=True)  # IT_WEIGHT
    item_grade = Column(String(30), nullable=True)  # IT_GRADE
    lamination_type = Column(String(30), nullable=True)  # IT_LAMINATION
    item_thickness = Column(String(30), nullable=True)  # IT_THICKNESS
    plant_id = Column(String(30), nullable=True)  # IT_PLANT_ID
    tech_specifications = Column(String(200), nullable=True)  # IT_TECH_SPEC
    recycled_uid = Column(String(30), nullable=True)  # RECYCLED_UID
    recycled_date = Column(Date, nullable=True)  # RECYCLED_DATE
    recycled_flag = Column(String(1), nullable=True)  # RECYCLED_FLAG
    previous_rate = Column(Float, nullable=True)  # PRIOR_RATE
    item_interface = Column(String(30), nullable=True)  # IT_INTERFACE
    item_color = Column(String(20), nullable=True)  # IT_COLOR
    item_shape = Column(String(50), nullable=True)  # IT_SHAPE
    preferred_customer_code = Column(String(30), nullable=True)  # PREFERD_CUS_CODE
    hs_code = Column(String(20), nullable=True)  # HSN_CODE
    critical_stock_level = Column(Integer, nullable=True)  # CRITICAL_STOCK
    purchase_account_code = Column(String(30), nullable=True)  # PR_AC_CODE
    sales_account_code = Column(String(30), nullable=True)  # SD_AC_CODE
    inventory_account_code = Column(String(30), nullable=True)  # CV_AC_CODE
    transfer_account_code = Column(String(30), nullable=True)  # BT_AC_CODE
    brand_account_code = Column(String(30), nullable=True)  # BR_AC_CODE
    goods_receipt_account_code = Column(String(30), nullable=True)  # GRN_AC_CODE
    group_code = Column(String(30), nullable=True)  # GROUP_CODE
    warranty_period_days = Column(Integer, nullable=True)  # WARRANTY_DAYS
    bundle_flag = Column(String(1), default='N', nullable=True)  # BUNDLE_FLAG
    sub_category_id = Column(Integer, nullable=True)  # SUB_CAT_ID
    saudable_item_flag = Column(String(1), default='N', nullable=True)  # SAUDA_IT_FLAG
    weight_gain_flag = Column(String(1), default='N', nullable=True)  # WT_GAIN_FLAG
    corrosion_flag = Column(String(1), default='N', nullable=True)  # COR_FLAG
    rate_difference_flag = Column(String(1), default='N', nullable=True)  # RATE_DIFF_FLAG
    fabric_flag = Column(String(1), default='N', nullable=True)  # BT_FABRIC_FLAG
    batch_flag = Column(String(1), default='N', nullable=True)  # BATCH_FLAG
    inward_quantity = Column(Integer, nullable=True)  # INWARD_QTY
    inward_rate = Column(Float, nullable=True)  # INWARD_RATE
    consumption_quantity = Column(Integer, nullable=True) # CONS_QTY

class Category(db.Model):
    __tablename__ = 'categories'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    category_name = Column(String(255), nullable=False)
    category_description = Column(Text)
    parent_category_id = Column(Integer, ForeignKey('categories.id'))
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class Transactions(db.Model):
    __tablename__ = 'Transactions'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    date = Column(Date, nullable=False)
    v_no = Column(String(255), nullable=False)
    com_code = Column(String(50), nullable=False)
    ac_code = Column(Integer, nullable=False)
    transaction_type = Column(String(50), nullable=False)
    debit = Column(DECIMAL(10, 2), default=0.00)  # Changed to DECIMAL
    credit = Column(DECIMAL(10, 2), default=0.00)  # Changed to DECIMAL
    attachments = Column(Text)
    remarks = Column(Text)
    next_followup = Column(Date)
    create_uid = Column(String(255), nullable=False)
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class GL(db.Model):
    __tablename__ = 'gl'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    master_code = Column(Integer)
    ac_name = Column(String(50), nullable=False)
    ac_code = Column(Integer, nullable=False)
    ac_abr = Column(String(255), nullable=False)
    address = Column(Text)
    contact1 = Column(String(50))
    whatsapp = Column(String(50))
    contact2 = Column(String(50))
    
    opening_dr = Column(DECIMAL(10, 2), default=0.00)  # Changed to DECIMAL
    opening_cr = Column(DECIMAL(10, 2), default=0.00)  # Changed to DECIMAL
    com_code = Column(String(50), nullable=False)

    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())
    pan = Column(String(255), nullable=False)
class Master(db.Model):
    __tablename__ = 'master'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    code = Column(Integer)
    master_type = Column(String(50), nullable=False)
    name = Column(String(255), nullable=False)
    abr = Column(String(50))
    display_name = Column(String(255))
    parent_id = Column(Integer)  # Assuming parent is a reference to another Master ID
    
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class User(db.Model):
    __tablename__ = 'users'
    user_id = Column(Integer, primary_key=True, autoincrement=True)  # Mapping USER_ID
    utype_id = Column(Integer)  # UTYPE_ID
    login_name = Column(String(30), nullable=False)  # LOGIN_NAME
    password = Column(String(100))  # PASSWORD
    user_full_name = Column(String(100), nullable=False)  # USER_FULL_NAME
    abbreviation_id = Column(String(30))  # ABBREVIATION_ID
    grand_user_id = Column(Integer)  # GRAND_USER_ID
    gsku_flag = Column(String(1), nullable=False)  # GSKU_FLAG
    user_cat_id = Column(String(20))  # USER_CAT_ID
    user_rcap_flag = Column(String(1))  # USER_RCAP_FLAG
    emp_code = Column(String(30))  # EMP_CODE
    ulock_flag = Column(String(1))  # ULOCK_FLAG
    uschedule_flag = Column(String(1))  # USCHEDULE_FLAG
    uholiday_login_flag = Column(String(1))  # UHOLIDAY_LOGIN_FLAG
    uhistory_flag = Column(String(1))  # UHISTORY_FLAG
    image_file_name = Column(String(300))  # IMAGE_FILE_NAME
    cr_limit_approval_stage = Column(Integer, default=0)  # CR_LIMIT_APROVAL_STAGE
    cr_limit_approval_amt = Column(Integer, default=0)  # CR_LIMIT_APROVAL_AMT
    suser_flag = Column(String(1))  # SUSER_FLAG
    ulock_time = Column(Integer)  # ULOCK_TIME
    mdm_gaccess_ctrl = Column(String(1))  # MDM_GACCESS_CTRL
    last_expiry_date = Column(Date)  # LAST_EXPIRY_DATE
    higher_rank_no = Column(Integer)  # HIGHER_RANK_NO
    universal_mdm_mdy_flag = Column(String(1), default='N')  # UNIVERSAL_MDM_MDY_FLAG
    digital_signature = Column(String(100))  # DIGITAL_SIGNATURE
    default_merge = Column(String(1), default='N')  # DEFAULT_MERGE
    remarks = Column(String(200))  # REMARKS
    com_code = Column(String(5), nullable=False)  # COM_CODE
    make_uid = Column(String(30))  # MAKE_UID
    make_date = Column(Date)  # MAKE_DATE
    mdy_uid = Column(String(30))  # MDY_UID
    mdy_date = Column(Date)  # MDY_DATE
    recycled_uid = Column(String(30))  # RECYCLED_UID
    recycled_date = Column(Date)  # RECYCLED_DATE
    recycled_flag = Column(String(1))  # RECYCLED_FLAG
    lm_flag = Column(String(1))  # LM_FLAG
    lm_admin_flag = Column(String(1))  # LM_ADMIN_FLAG
    dashboard_logon_flag = Column(String(1))  # DASHBOARD_LOGON_FLAG
    fico_dept = Column(String(1))  # FICO_DEPT
    pr_dept = Column(String(1))  # PR_DEPT
    ivm_dept = Column(String(1))  # IVM_DEPT
    mfg_dept = Column(String(1))  # MFG_DEPT
    sd_dept = Column(String(1))  # SD_DEPT
    user_belong_to = Column(Integer)  # USER_BELONG_TO
    mdm_code = Column(String(30))  # MDM_CODE
    mdm_flag = Column(String(1))  # MDM_FLAG
    designation = Column(String(30))  # DESIGNATION
    mobile_no = Column(String(15))  # MOBILE_NO
    mobile_access = Column(String(1))  # MOBILE_ACCESS
    
    
    created_at = Column(Date, server_default=func.now())
    updated_at = Column(Date, server_default=func.now(), onupdate=func.now())
    com_code = Column(String(10))  # MOBILE_ACCESS
class fin_jv_transaction(db.Model):
    __tablename__ = 'fin_jv_transaction'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    ref_no = Column(Integer, nullable=False)  # Added account ID
    v_no = Column(String(255), nullable=False)
    v_date = Column(Date, nullable=False)  # Added field for transaction date
    sr_no = Column(Integer, nullable=False)  # Serial number
    ac_code = Column(Integer, nullable=False)  # Changed to Integer for consistency
    ac_id = Column(Integer, nullable=False)  # Added account ID
    descriptions = Column(Text)  # Added descriptions
    dr_amount = Column(DECIMAL(10, 2), default=0.00)  # Debit amount
    cr_amount = Column(DECIMAL(10, 2), default=0.00)  # Credit amount
    com_code = Column(String(50), nullable=False)  # Company code

    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())
class prk_ParkingOperation(db.Model):
    __tablename__ = 'prk_ParkingOperation' 
    id = Column(Integer, primary_key=True, autoincrement=True)
    type = Column(String(50), nullable=False)  # Type of parking operation
    motorist_name = Column(String(255), nullable=False)  # Motorist's name
    vehicle_plate_no = Column(String(50), nullable=False)  # Vehicle plate number
    vehicle_reg_office = Column(String(255), nullable=True)  # Vehicle registration office
    date = Column(Date, server_default=func.now())  # Date of operation
    park_in_time = Column(TIMESTAMP, server_default=func.now())  # Time when parked in
    park_out_time = Column(TIMESTAMP, nullable=True)  # Time when parked out
    total_park_time = Column(DECIMAL(10, 2), default=0.00)  # Total parking time
    amount = Column(DECIMAL(10, 2), default=0.00)  # Amount charged
    paid_type = Column(String(50), nullable=True)  # Type of payment (e.g., cash, card)
    free_references = Column(Text, nullable=True)  # Free references, if any
    pay_status = Column(String(50), nullable=True)  # Payment status (e.g., paid, unpaid)
    attachments = Column(Text, nullable=True)  # Attachments related to the parking operation
    remarks = Column(Text, nullable=True)  # Any remarks
    parking_area = Column(String(255), nullable=True)  # Parking area
    parking_slot = Column(String(50), nullable=True)  # Parking slot number
    free_references_attachments = Column(Text, nullable=True)  # Attachments for free references
    park_in_uid = Column(Integer, nullable=True)  # User ID for parking in
    park_out_uid = Column(Integer, nullable=True)  # User ID for parking out
    com_code = Column(Integer, nullable=True)  # User ID for parking out
    
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())
    

class Prk_motor_type(db.Model):
    __tablename__ = 'Prk_motor_type'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    type = Column(String(50), nullable=False)  # Type of parking operation
    
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())
class ParkingRateSetup(db.Model):
    __tablename__ = 'prk_parking_rate_setup'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    motor_type = Column(String(50), nullable=False)  # Type of motor vehicle
    hour_rate = Column(DECIMAL(10, 2), nullable=False)  # Rate per hour
    interval_rate = Column(DECIMAL(10, 2), nullable=False)  # Rate for intervals
    interval_minutes = Column(Integer, nullable=False)  # Duration of interval in minutes
    
    created_at = Column(TIMESTAMP, server_default=func.now())
    updated_at = Column(TIMESTAMP, server_default=func.now(), onupdate=func.now())

class master_shop_type(db.Model):
    __tablename__ = 'master_shop_type'

    id = Column(Integer, Sequence('shop_type_seq'), primary_key=True)
    name = Column(String(255), nullable=True)
    
class master_service_area(db.Model):
    __tablename__ = 'master_service_area'

    id = Column(Integer, Sequence('service_area_seq'), primary_key=True)
    name = Column(String(255), nullable=True)
    
class master_business_category(db.Model):
    __tablename__ = 'master_business_category'

    id = Column(Integer, Sequence('business_category_seq'), primary_key=True)
    name = Column(String(255), nullable=True)

#Toys
class Toys_User_Detail(db.Model):
    __tablename__ = 'Toys_User_Detail'

    id = Column(Integer, Sequence('user_detail_seq'), primary_key=True)
    name = Column(String(255), nullable=False)
    date_of_birth = Column(Date, nullable=True)
    gender = Column(String(10), nullable=True)  # e.g., "Male", "Female", "Other"
    email = Column(String(255), unique=True, nullable=False)
    address = Column(String(255), nullable=True)
    contact = Column(String(15), nullable=True)  # Can be changed based on format of contact
    gov_id_type = Column(String(50), nullable=True)  # Type of govt. ID, e.g., "Aadhaar", "Passport"
    gov_id_no = Column(String(100), nullable=True)
    image_front = Column(String(255), nullable=True)  # Path to front image (can be URL or local path)
    image_back = Column(String(255), nullable=True)   # Path to back image (can be URL or local path)
    password = Column(String(255), nullable=False)  # Store hashed password
    active_flag = Column(Boolean, default=True)  # Indicates if the account is active
    balance = Column(DECIMAL(10, 2), nullable=False)  # Assume balance is a float
    remarks = Column(String(255), nullable=True)  # Any additional remarks about the user
    user_mode = Column(String(50), nullable=True)  # User type or mode, e.g., "Admin", "Driver", etc.
    vehicle_type = Column(String(50), nullable=True)  # Type of vehicle, e.g., "Car", "Truck"
    vehicle_no = Column(String(20), nullable=True)  # Vehicle registration number
    vehicle_color = Column(String(50), nullable=True)  # Vehicle color
    vehicle_image = Column(String(255), nullable=True)  # Path to vehicle image (can be URL or local path)
    current_lat = Integer  # Latitude for location
    current_lon =Integer  # Longitude for location
    login_id = Column(Integer, nullable=True)  # Login ID (integer, can be linked in application logic)
    driver_id = Column(Integer, nullable=True)  # Driver ID (integer, can be linked in application logic)
    
class Toys_Product(db.Model):
    __tablename__ = 'Toys_Product'

    id = Column(Integer, Sequence('seq_Toys_Product'), primary_key=True)
    name = Column(String(255), nullable=True)
class Toys_Vehicle_type(db.Model):
    __tablename__ = 'Toys_Vehicle_type'
    id = Column(Integer, Sequence('seq_Toys_Product'), primary_key=True)
    name = Column(String(255), nullable=True)
class Toys_Ride_Transaction(db.Model):
    __tablename__ = 'Toys_Ride_Transaction'

    tran_id = Column(Integer, Sequence('transaction_seq'), primary_key=True)
    login_id = Column(Integer, nullable=False)  # Assuming login_id refers to the User login ID
    product_id = Column(Integer, nullable=False)  # Product ID - assuming this refers to a product (could be linked manually)
    vehicle_type = Column(String(50), nullable=True)  # Type of vehicle involved in the transaction (e.g., "Car", "Truck")
    
    from_lat = Column(Integer, nullable=True)  # Starting latitude
    from_lon = Column(Integer, nullable=True)  # Starting longitude
    from_location_name = Column(String(255), nullable=True)  # Name of the starting location (could be address or place name)
    
    to_lat = Column(Integer, nullable=True)  # Destination latitude
    to_lon = Column(Integer, nullable=True)  # Destination longitude
    to_location_name = Column(String(255), nullable=True)  # Name of the destination location
    
    fare_amount = Column(DECIMAL, nullable=True)  # Total fare amount for the transaction
    commission_amount = Column(DECIMAL, nullable=True)  # Commission amount for the transaction
    
    customer_paid_status = Column(Boolean, default=False)  # Whether the customer has paid (True/False)
    commission_paid_status = Column(Boolean, default=False)  # Whether the commission has been paid (True/False)
    
    # Optional: You can add a timestamp for when the transaction occurred
    transaction_time = Column(TIMESTAMP, nullable=True)  # Time of transaction (can be set when created)

class Toys_Transaction_Detail(db.Model):
    __tablename__ = 'Toys_Transaction_Detail'

    tran_detail_id = Column(Integer, Sequence('transaction_detail_seq'), primary_key=True)
    tran_id = Column(Integer, nullable=False)  # Link to Transaction using tran_id
    date_time = Column(TIMESTAMP, nullable=False)  # Timestamp for when this detail was recorded
    lat = Column(Integer, nullable=True)  # Latitude of the transaction detail
    lon = Column(Integer, nullable=True)  # Longitude of the transaction detail
    remarks = Column(String(255), nullable=True)  # Any additional remarks for this transaction detail
class Toys_Fare_Setup(db.Model):
    __tablename__ = 'Toys_Fare_Setup'

    id = Column(Integer, Sequence('fare_setup_seq'), primary_key=True)
    fdate = Column(Date, nullable=False)  # Fare setup start date
    tdate = Column(Date, nullable=False)  # Fare setup end date
    vehicle_type = Column(Integer, nullable=False)  # Type of vehicle (e.g., "Car", "Truck", etc.)
    product_id = Column(Integer, nullable=False)  # ID of the product/service for which fare is set
    fare_amt_per_km = Column(DECIMAL(10, 2), nullable=False)  # Fare amount per kilometer (Decimal with 2 decimal places)
    minimum_price = Column(DECIMAL(10, 2), nullable=False)  # Minimum fare for the ride (Decimal with 2 decimal places)
    maximum_price = Column(DECIMAL(10, 2), nullable=False)  # Maximum fare (Decimal with 2 decimal places)
    comission_type =  Column(String(50), nullable=False)
    comission_per = Column(DECIMAL(10, 2), nullable=False) 
    