from flask import Blueprint, render_template, jsonify, request,redirect
from flask_jwt_extended import create_access_token, jwt_required,get_jwt_identity
from . import db
from .models import *  # Import your models
from datetime import datetime, timedelta
import os
master = Blueprint('master', __name__)




@master.route('/item_master')
def item_master():
    return render_template('prk_template/item_master.html')

@master.route('/master_home')
def master_home():
    return render_template('master_template/master_operation.html')

@master.route('/item_master_data_insertion', methods=['POST'])
@jwt_required()
def item_master_insertion():
    current_user = get_jwt_identity()
    print(f"current_user:{current_user}")
    com_code = current_user.get('com_code')
    user_id = current_user.get('user_id')
    qry = 'select nvl(max(item_code)+1, 1) as id from item_info'
    res_record = db.session.execute(qry)

    for res in res_record:
        max_id = res.id

    item_code = (f"A{max_id}")

    # Get form data
    data = request.form.to_dict()
    sales_price_applied_on = data.get('sales_price_applied_on') or ''
    tax_type_select = data.get('tax_type_select') or ''

    print(f"sales_price_applied_on:{sales_price_applied_on}")

    # Save the store info
    item_info = ITEM_INFO(
        com_code= int(com_code), 
        dealer_name=data.get('dealer_name'),
        address=data.get('address'),
        owner_name=data.get('owner_name'),
        allotted_address=data.get('alloted_address'),
        email=data.get('email'),
        contact1=data.get('contact1'),
        contact2=data.get('contact2'),
        remarks=data.get('remarks'),
        active_flag = 'Y',
        lock_flag = 'N',
        created_by= user_id,
        id_type= id_type,
        id_no=data.get('id_number'),
        id_image1 = id_image1,
        id_image2 = id_image2,
        profile_image = profile_image,
        agent_code =  agent_code,
        dealer_agent = 'BM'

    )

    # Add the store info to the session and commit
    db.session.add(dealer_info)
    db.session.commit()


    # Return a success response
    response_data = {
        'message': 'Store data received and saved successfully',
        'item_info': {
            'item_code': item_info.item_code,
        }
        # 'uploaded_files': saved_files
    }
    
    return jsonify(response_data)





