import os

class Config:
    SQLALCHEMY_TRACK_MODIFICATIONS = False

    # Define the path for the databases and other files
    BASE_DIR = os.path.abspath(os.path.dirname(__file__))  # Get the directory of the current file
    SQLITE_DATABASE_URI = 'sqlite:///' + os.path.join(BASE_DIR, 'default.db')
    MYSQL_DATABASE_URI = 'mysql+pymysql://root:@localhost/bm'  # Update with your MySQL user and password
    # ORACLE_DATABASE_URI = 'oracle+cx_oracle://PBRAIN_CRM:PBRAIN_CRM@Hackeraj:1521/RAAZ'  # Update with Oracle details
    ORACLE_DATABASE_URI = 'oracle+cx_oracle://BM8182:BM8182@DESKTOP-N0TLARH:1521/RAAZ'  # Update with Oracle details

    # Define the path for the MS Access database in the project directory
    MSACCESS_DATABASE_URI = (
       "access+pyodbc:///?odbc_connect="
    "Driver={Microsoft Access Driver (*.mdb, *.accdb)};"
    "Dbq=E:\\umesh\\bmpy\\app\\database.accdb;"
    )

    # Excel file path
    EXCEL_FILE_PATH = os.path.join(BASE_DIR, 'file.xlsx')

    # Database type (default is SQLite)
    DB_TYPE = 'oracle'  # Change this to 'mysql', 'oracle', 'msaccess', or 'excel' as needed

    @staticmethod
    def get_database_uri():
        if Config.DB_TYPE == 'mysql':
            return Config.MYSQL_DATABASE_URI
        elif Config.DB_TYPE == 'oracle':
            return Config.ORACLE_DATABASE_URI
        elif Config.DB_TYPE == 'msaccess':
            return Config.MSACCESS_DATABASE_URI
        elif Config.DB_TYPE == 'excel':
            # Handle Excel case (e.g., load with pandas instead)
            return None  # Excel doesn't use SQLAlchemy for database URI
        else:
            return Config.SQLITE_DATABASE_URI  # Default to SQLite

# Example usage:
# You can set the URI in your Flask app's configuration like this:
# app.config['SQLALCHEMY_DATABASE_URI'] = Config.get_database_uri()
