from flask import Flask
from flask_jwt_extended import JWTManager
from flask_cors import CORS
from flask_migrate import Migrate
from .config import Config
from .database import db  # Import the db instance from the new file
from .models import *  # Import models here after db is defined

def create_app():
    app = Flask(__name__)
    app.config.from_object(Config)
    app.config['JWT_SECRET_KEY'] = 'your_secret_key'
    
    # Set the SQLALCHEMY_DATABASE_URI from the Config class
    app.config['SQLALCHEMY_DATABASE_URI'] = Config.get_database_uri()

    CORS(app, support_credentials=True)

    # Initialize extensions
    db.init_app(app)
    migrate = Migrate(app, db)
    jwt = JWTManager(app)

    # Create tables and insert default data if they do not exist
    with app.app_context():
        db.create_all()
        insert_default_data()

    # Register blueprints
    from .routes import main
    from .prk_routes import prk
    from .master_routes import master
    app.register_blueprint(main)
    app.register_blueprint(prk)
    app.register_blueprint(master)

    return app

def insert_default_dataX():
    default_data = [
        {"code": 101, "master_type": "1", "name": "Capital Account", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 102, "master_type": "1", "name": "Current Assets", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 103, "master_type": "1", "name": "Current Liabilities", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 104, "master_type": "1", "name": "Fixed Assets", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 105, "master_type": "1", "name": "Investments", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 106, "master_type": "1", "name": "Loans (Liability)", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 107, "master_type": "1", "name": "Pre-Operative Expenses", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 108, "master_type": "1", "name": "Profit & Loss", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 109, "master_type": "1", "name": "Revenue Accounts", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 110, "master_type": "1", "name": "Suspense Account", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 111, "master_type": "1", "name": "Cash-in-hand", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 112, "master_type": "1", "name": "Bank Accounts", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 113, "master_type": "1", "name": "Securities & Deposits (Asset)", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 114, "master_type": "1", "name": "Loans & Advances (Asset)", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 115, "master_type": "1", "name": "Stock-in-hand", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 116, "master_type": "1", "name": "Sundry Debtors", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 117, "master_type": "1", "name": "Sundry Creditors", "abr": "", "display_name": "", "parent_id": 103},
        {"code": 118, "master_type": "1", "name": "Duties & Taxes", "abr": "", "display_name": "", "parent_id": 103},
        {"code": 119, "master_type": "1", "name": "Provisions/Expenses Payable", "abr": "", "display_name": "", "parent_id": 103},
        {"code": 120, "master_type": "1", "name": "Secured Loans", "abr": "", "display_name": "", "parent_id": 106},
        {"code": 121, "master_type": "1", "name": "Unsecured Loans", "abr": "", "display_name": "", "parent_id": 106},
        {"code": 122, "master_type": "1", "name": "Purchase", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 123, "master_type": "1", "name": "Sales", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 124, "master_type": "1", "name": "Expenses (Direct/Mfg.)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 125, "master_type": "1", "name": "Expenses (Indirect/Admn.)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 126, "master_type": "1", "name": "Income (Direct/Opr.)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 127, "master_type": "1", "name": "Income (Indirect)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 128, "master_type": "1", "name": "Bank O/D Account", "abr": "", "display_name": "", "parent_id": 106},
        {"code": 129, "master_type": "1", "name": "Reserves & Surplus", "abr": "", "display_name": "", "parent_id": 101},
        {"code": 1, "master_type": "2", "name": "Cash", "abr": "", "display_name": "Cash", "parent_id": 111},
        {"code": 2, "master_type": "2", "name": "Profit & Loss", "abr": "", "display_name": "Profit & Loss", "parent_id": 108},
        {"code": 3, "master_type": "2", "name": "Stock", "abr": "", "display_name": "Stock", "parent_id": 115},
        {"code": 4, "master_type": "2", "name": "Sales", "abr": "", "display_name": "Sales", "parent_id": 123},
        {"code": 5, "master_type": "2", "name": "Purchase", "abr": "", "display_name": "Purchase", "parent_id": 122},
    ]

    for data in default_data:
        master_entry = Master.query.filter_by(code=data['code']).first()  # Check if it exists

        if master_entry:
            # Update existing entry
            master_entry.master_type = data['master_type']
            master_entry.name = data['name']
            master_entry.abr = data['abr']
            master_entry.display_name = data['display_name']
            master_entry.parent_id = data['parent_id']
        else:
            # Insert new entry
            master_entry = Master(**data)
            db.session.add(master_entry)

    db.session.commit()  # Commit all changes at once
    default_data_account = [
    {"master_code": 1, "master_type": "2", "name": "Cash", "abr": "", "display_name": "Cash", "parent_id": 111},
    {"master_code": 2, "master_type": "2", "name": "Profit & Loss", "abr": "", "display_name": "Profit & Loss", "parent_id": 108},
    {"master_code": 3, "master_type": "2", "name": "Stock", "abr": "", "display_name": "Stock", "parent_id": 115},
    {"master_code": 4, "master_type": "2", "name": "Sales", "abr": "", "display_name": "Sales", "parent_id": 123},
    {"master_code": 5, "master_type": "2", "name": "Purchase", "abr": "", "display_name": "Purchase", "parent_id": 122},
]

    for data in default_data_account:
        master_entry = GL.query.filter_by(master_code=data['master_code']).first()  # Check if it exists

        if master_entry:
            # Update existing entry
            master_entry.master_code = data['master_code']
            master_entry.ac_name = data['name']
            master_entry.ac_abr = data['name']
            master_entry.ac_code = data['master_code']
            
        else:
            # Insert new entry
            master_entry = GL(**data)
            db.session.add(master_entry)

    db.session.commit()  # Commit all changes at once
def insert_default_data():
    default_data = [
        {"code": 101, "master_type": "1", "name": "Capital Account", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 102, "master_type": "1", "name": "Current Assets", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 103, "master_type": "1", "name": "Current Liabilities", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 104, "master_type": "1", "name": "Fixed Assets", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 105, "master_type": "1", "name": "Investments", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 106, "master_type": "1", "name": "Loans (Liability)", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 107, "master_type": "1", "name": "Pre-Operative Expenses", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 108, "master_type": "1", "name": "Profit & Loss", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 109, "master_type": "1", "name": "Revenue Accounts", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 110, "master_type": "1", "name": "Suspense Account", "abr": "", "display_name": "", "parent_id": 0},
        {"code": 111, "master_type": "1", "name": "Cash-in-hand", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 112, "master_type": "1", "name": "Bank Accounts", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 113, "master_type": "1", "name": "Securities & Deposits (Asset)", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 114, "master_type": "1", "name": "Loans & Advances (Asset)", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 115, "master_type": "1", "name": "Stock-in-hand", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 116, "master_type": "1", "name": "Sundry Debtors", "abr": "", "display_name": "", "parent_id": 102},
        {"code": 117, "master_type": "1", "name": "Sundry Creditors", "abr": "", "display_name": "", "parent_id": 103},
        {"code": 118, "master_type": "1", "name": "Duties & Taxes", "abr": "", "display_name": "", "parent_id": 103},
        {"code": 119, "master_type": "1", "name": "Provisions/Expenses Payable", "abr": "", "display_name": "", "parent_id": 103},
        {"code": 120, "master_type": "1", "name": "Secured Loans", "abr": "", "display_name": "", "parent_id": 106},
        {"code": 121, "master_type": "1", "name": "Unsecured Loans", "abr": "", "display_name": "", "parent_id": 106},
        {"code": 122, "master_type": "1", "name": "Purchase", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 123, "master_type": "1", "name": "Sales", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 124, "master_type": "1", "name": "Expenses (Direct/Mfg.)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 125, "master_type": "1", "name": "Expenses (Indirect/Admn.)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 126, "master_type": "1", "name": "Income (Direct/Opr.)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 127, "master_type": "1", "name": "Income (Indirect)", "abr": "", "display_name": "", "parent_id": 109},
        {"code": 128, "master_type": "1", "name": "Bank O/D Account", "abr": "", "display_name": "", "parent_id": 106},
        {"code": 129, "master_type": "1", "name": "Reserves & Surplus", "abr": "", "display_name": "", "parent_id": 101},
        {"code": 1, "master_type": "2", "name": "Cash", "abr": "", "display_name": "Cash", "parent_id": 111},
        {"code": 2, "master_type": "2", "name": "Profit & Loss", "abr": "", "display_name": "Profit & Loss", "parent_id": 108},
        {"code": 3, "master_type": "2", "name": "Stock", "abr": "", "display_name": "Stock", "parent_id": 115},
        {"code": 4, "master_type": "2", "name": "Sales", "abr": "", "display_name": "Sales", "parent_id": 123},
        {"code": 5, "master_type": "2", "name": "Purchase", "abr": "", "display_name": "Purchase", "parent_id": 122},
    ]

    # Insert default data into Master
    for data in default_data:
        master_entry = Master.query.filter_by(code=data['code']).first()  # Check if it exists

        if master_entry:
            # Update existing entry
            master_entry.master_type = data['master_type']
            master_entry.name = data['name']
            master_entry.abr = data['abr']
            master_entry.display_name = data['display_name']
            master_entry.parent_id = data['parent_id']
        else:
            # Insert new entry
            master_entry = Master(**data)
            # db.session.add(master_entry)

    db.session.commit()  # Commit all changes at once

    default_data_account = [
        {"master_code": 1, "master_type": "2", "name": "Cash", "abr": "", "display_name": "Cash", "parent_id": 111, "ac_code": 1},
        {"master_code": 2, "master_type": "2", "name": "Profit & Loss", "abr": "", "display_name": "Profit & Loss", "parent_id": 108, "ac_code": 2},
        {"master_code": 3, "master_type": "2", "name": "Stock", "abr": "", "display_name": "Stock", "parent_id": 115, "ac_code": 3},
        {"master_code": 4, "master_type": "2", "name": "Sales", "abr": "", "display_name": "Sales", "parent_id": 123, "ac_code": 4},
        {"master_code": 5, "master_type": "2", "name": "Purchase", "abr": "", "display_name": "Purchase", "parent_id": 122, "ac_code": 5},
        {"master_code": 6, "master_type": "2", "name": "Sales Return", "abr": "", "display_name": "Purchase", "parent_id": 122, "ac_code": 6},
        {"master_code": 7, "master_type": "2", "name": "Purchase Return", "abr": "", "display_name": "Purchase", "parent_id": 122, "ac_code": 7},
    ]

    # Insert default data into GL
    for data in default_data_account:
        master_entry = GL.query.filter_by(master_code=data['master_code']).first()  # Check if it exists

        if master_entry:
            # Update existing entry
            master_entry.ac_name = data['name']
            master_entry.ac_abr = data['abr']
            master_entry.ac_code = data['ac_code']
            # Optionally set other fields if needed
        else:
            # Insert new entry
            master_entry = GL(
                master_code=data['master_code'],
                ac_name=data['name'],
                ac_code=data['ac_code'],
                ac_abr=data['abr'],
                address=None,  # Set to None or default value if needed
                contact1=None,  # Set to None or default value if needed
                whatsapp=None,  # Set to None or default value if needed
                contact2=None,  # Set to None or default value if needed
                opening_dr=0.00,
                opening_cr=0.00,
                com_code="",  # Set a default company code if necessary
                pan=""  # Set a default PAN if necessary
            )
            # db.session.add(master_entry)

    db.session.commit()  # Commit all changes at once
