from flask import Blueprint, render_template,jsonify,request
from flask_jwt_extended import create_access_token, jwt_required

main = Blueprint('main', __name__)

users = {
    "admin": "admin",
    "user2": "password2"
}

@main.route('/')
def index():
    return 'success'
    #return render_template('index.html')
@main.route('/lpage')
def lpage():
    return render_template('login.html')
@main.route('/login', methods=['POST'])
def login():
    # Get the JSON data from the request
    data = request.get_json()

    # Extract username and password from the request data
    username = data.get('username')
    password = data.get('password')

    # Check if the username exists and the password matches
    if username in users and users[username] == password:
        # Create a new access token
        access_token = create_access_token(identity=username)
        return jsonify(access_token=access_token), 200

    return jsonify({"msg": "Bad username or password"}), 401

@main.route('/protected', methods=['GET'])
@jwt_required()
def protected():
    return jsonify(msg="This is a protected route"), 200